/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.api;

import io.github.steaf23.bingoreloaded.lib.api.StatisticType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.bukkit.Statistic;
import org.jetbrains.annotations.NotNull;

public class StatisticTypePaper
implements StatisticType {
    public static Map<Statistic, StatisticType.StatisticCategory> STATISTIC_CATEGORY_MAP = StatisticTypePaper.makeStatisticMap();
    private final Statistic stat;

    private static Map<Statistic, StatisticType.StatisticCategory> makeStatisticMap() {
        HashMap<Statistic, StatisticType.StatisticCategory> map = new HashMap<Statistic, StatisticType.StatisticCategory>();
        for (Statistic stat : Statistic.values()) {
            map.put(stat, new StatisticTypePaper(stat).getCategory());
        }
        return map;
    }

    public StatisticTypePaper(Statistic stat) {
        this.stat = stat;
    }

    public Statistic handle() {
        return this.stat;
    }

    @Override
    @NotNull
    public Key key() {
        return this.stat.key();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StatisticTypePaper) {
            StatisticTypePaper other = (StatisticTypePaper)obj;
            return this.stat.equals((Object)other.stat);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hashCode(this.stat);
    }

    @Override
    public StatisticType.StatisticCategory getCategory() {
        return switch (this.stat) {
            default -> throw new MatchException(null, null);
            case Statistic.DROP, Statistic.PICKUP, Statistic.USE_ITEM, Statistic.BREAK_ITEM, Statistic.CRAFT_ITEM, Statistic.KILL_ENTITY, Statistic.ENTITY_KILLED_BY, Statistic.MINE_BLOCK -> StatisticType.StatisticCategory.ROOT_STATISTIC;
            case Statistic.DAMAGE_DEALT, Statistic.DAMAGE_TAKEN, Statistic.DAMAGE_DEALT_ABSORBED, Statistic.DAMAGE_DEALT_RESISTED, Statistic.DAMAGE_RESISTED, Statistic.DAMAGE_ABSORBED, Statistic.DAMAGE_BLOCKED_BY_SHIELD -> StatisticType.StatisticCategory.DAMAGE;
            case Statistic.TALKED_TO_VILLAGER, Statistic.TRADED_WITH_VILLAGER, Statistic.DEATHS, Statistic.MOB_KILLS, Statistic.PLAYER_KILLS, Statistic.FISH_CAUGHT, Statistic.ANIMALS_BRED, Statistic.LEAVE_GAME, Statistic.JUMP, Statistic.DROP_COUNT, Statistic.PLAY_ONE_MINUTE, Statistic.TOTAL_WORLD_TIME, Statistic.SNEAK_TIME, Statistic.TIME_SINCE_DEATH, Statistic.RAID_TRIGGER, Statistic.ARMOR_CLEANED, Statistic.BANNER_CLEANED, Statistic.ITEM_ENCHANTED, Statistic.TIME_SINCE_REST, Statistic.RAID_WIN, Statistic.TARGET_HIT, Statistic.CLEAN_SHULKER_BOX -> StatisticType.StatisticCategory.OTHER;
            case Statistic.CAKE_SLICES_EATEN, Statistic.CAULDRON_FILLED, Statistic.BREWINGSTAND_INTERACTION, Statistic.BEACON_INTERACTION, Statistic.NOTEBLOCK_PLAYED, Statistic.CAULDRON_USED, Statistic.NOTEBLOCK_TUNED, Statistic.FLOWER_POTTED, Statistic.RECORD_PLAYED, Statistic.FURNACE_INTERACTION, Statistic.CRAFTING_TABLE_INTERACTION, Statistic.SLEEP_IN_BED, Statistic.INTERACT_WITH_BLAST_FURNACE, Statistic.INTERACT_WITH_SMOKER, Statistic.INTERACT_WITH_LECTERN, Statistic.INTERACT_WITH_CAMPFIRE, Statistic.INTERACT_WITH_CARTOGRAPHY_TABLE, Statistic.INTERACT_WITH_LOOM, Statistic.INTERACT_WITH_STONECUTTER, Statistic.BELL_RING, Statistic.INTERACT_WITH_ANVIL, Statistic.INTERACT_WITH_GRINDSTONE, Statistic.INTERACT_WITH_SMITHING_TABLE -> StatisticType.StatisticCategory.BLOCK_INTERACT;
            case Statistic.OPEN_BARREL, Statistic.CHEST_OPENED, Statistic.ENDERCHEST_OPENED, Statistic.SHULKER_BOX_OPENED, Statistic.TRAPPED_CHEST_TRIGGERED, Statistic.HOPPER_INSPECTED, Statistic.DROPPER_INSPECTED, Statistic.DISPENSER_INSPECTED -> StatisticType.StatisticCategory.CONTAINER_INTERACT;
            case Statistic.STRIDER_ONE_CM, Statistic.MINECART_ONE_CM, Statistic.CLIMB_ONE_CM, Statistic.FLY_ONE_CM, Statistic.WALK_UNDER_WATER_ONE_CM, Statistic.BOAT_ONE_CM, Statistic.PIG_ONE_CM, Statistic.HORSE_ONE_CM, Statistic.CROUCH_ONE_CM, Statistic.AVIATE_ONE_CM, Statistic.WALK_ONE_CM, Statistic.WALK_ON_WATER_ONE_CM, Statistic.SWIM_ONE_CM, Statistic.FALL_ONE_CM, Statistic.SPRINT_ONE_CM, Statistic.HAPPY_GHAST_ONE_CM -> StatisticType.StatisticCategory.TRAVEL;
        };
    }
}

