/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.api;

import io.github.steaf23.bingoreloaded.lib.api.BiomeType;
import io.github.steaf23.bingoreloaded.lib.api.BiomeTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.DimensionType;
import io.github.steaf23.bingoreloaded.lib.api.EntityType;
import io.github.steaf23.bingoreloaded.lib.api.EntityTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.PaperApiHelper;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandlePaper;
import io.github.steaf23.bingoreloaded.lib.util.DebugLogger;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.World;

public class WorldHandlePaper
implements WorldHandle {
    private final World world;

    public WorldHandlePaper(World world) {
        this.world = world;
    }

    @Override
    public String name() {
        return this.world.getName();
    }

    @Override
    public UUID uniqueId() {
        return this.world.getUID();
    }

    @Override
    public Collection<? extends PlayerHandle> players() {
        return this.world.getPlayers().stream().map(PlayerHandlePaper::new).toList();
    }

    @Override
    public WorldPosition spawnPoint() {
        DebugLogger.addLog("Spawn point of " + this.name() + ": " + String.valueOf(this.world.getSpawnLocation()));
        return PaperApiHelper.worldPosFromLocation(this.world.getSpawnLocation());
    }

    @Override
    public DimensionType dimension() {
        return switch (this.world.getEnvironment()) {
            case World.Environment.NETHER -> DimensionType.NETHER;
            case World.Environment.THE_END -> DimensionType.THE_END;
            default -> DimensionType.OVERWORLD;
        };
    }

    @Override
    public void spawnEntity(EntityType type, WorldPosition pos) {
        this.world.spawnEntity(PaperApiHelper.locationFromWorldPos(pos), ((EntityTypePaper)type).handle());
    }

    @Override
    public void setStorming(boolean storm) {
        this.world.setStorm(storm);
    }

    @Override
    public void setTimeOfDay(long time) {
        this.world.setTime(time);
    }

    @Override
    public BiomeType biomeAtPos(WorldPosition pos) {
        return new BiomeTypePaper(this.world.getBiome(PaperApiHelper.locationFromWorldPos(pos)));
    }

    @Override
    public ItemType typeAtPos(WorldPosition pos) {
        return ItemType.of(this.world.getType(pos.blockX(), pos.blockY(), pos.blockZ()).key());
    }

    @Override
    public void setTypeAtPos(WorldPosition pos, ItemType type) {
        this.world.setType(PaperApiHelper.locationFromWorldPos(pos), ((ItemTypePaper)type).handle());
    }

    @Override
    public WorldPosition highestBlockAt(WorldPosition pos) {
        return PaperApiHelper.worldPosFromLocation(this.world.getHighestBlockAt(pos.blockX(), pos.blockZ()).getLocation());
    }

    @Override
    public void dropItem(StackHandle item, WorldPosition location) {
        this.world.dropItem(PaperApiHelper.locationFromWorldPos(location), ((StackHandlePaper)item).handle());
    }

    public World handle() {
        return this.world;
    }
}

