/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.api.item;

import io.github.steaf23.bingoreloaded.lib.api.item.InventoryHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandlePaper;
import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InventoryHandlePaper
implements InventoryHandle {
    private final Inventory inventory;

    public InventoryHandlePaper(Inventory inventory) {
        this.inventory = inventory;
    }

    public Inventory handle() {
        return this.inventory;
    }

    @Override
    public void setItem(int index, StackHandle stack) {
        this.inventory.setItem(index, ((StackHandlePaper)stack).handle());
    }

    @Override
    public HashMap<Integer, StackHandle> addItem(StackHandle ... stacks) {
        HashMap result = this.inventory.addItem((ItemStack[])Arrays.stream(stacks).map(s -> ((StackHandlePaper)s).handle()).toArray(ItemStack[]::new));
        HashMap<Integer, StackHandle> returnedHandles = new HashMap<Integer, StackHandle>();
        for (Integer idx : result.keySet()) {
            returnedHandles.put(idx, new StackHandlePaper((ItemStack)result.get(idx)));
        }
        return returnedHandles;
    }

    @Override
    @NotNull
    public StackHandle getItem(int index) {
        ItemStack stack = this.inventory.getItem(index);
        if (stack == null) {
            return StackHandle.create(ItemType.AIR);
        }
        return new StackHandlePaper(stack);
    }

    @Override
    public void removeItem(StackHandle stack) {
        this.inventory.remove(((StackHandlePaper)stack).handle());
    }

    @Override
    public StackHandle[] contents() {
        return (StackHandle[])Arrays.stream(this.inventory.getContents()).map(StackHandlePaper::new).toArray(StackHandle[]::new);
    }

    @Override
    public void clearContents() {
        this.inventory.clear();
    }

    @Override
    public void setContents(StackHandle[] contents) {
        this.inventory.setContents((ItemStack[])Arrays.stream(contents).map(s -> ((StackHandlePaper)s).handle()).toArray(ItemStack[]::new));
    }
}

