/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.api.item;

import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.StackBuilder;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandlePaper;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.util.PDCHelper;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import io.papermc.paper.datacomponent.item.UseCooldown;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.keys.DataComponentTypeKeys;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Color;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;

public class StackBuilderPaper
implements StackBuilder {
    @Override
    public StackHandle buildItem(ItemTemplate template, boolean hideAttributes, boolean customTextures) {
        ItemMeta meta;
        List<Component> descriptionList = template.buildDescriptionList();
        ItemStack stack = new ItemStack(((ItemTypePaper)template.getItemType()).handle(), template.getAmount());
        if (template.getName() != null) {
            stack.setData(DataComponentTypes.CUSTOM_NAME, (Object)template.getName().colorIfAbsent(NamedTextColor.WHITE).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE));
        }
        stack.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)template.isGlowing());
        stack.setData(DataComponentTypes.LORE, (Object)ItemLore.lore(descriptionList));
        Integer maxDamage = template.getMaxDamage();
        if (maxDamage != null) {
            stack.setData(DataComponentTypes.MAX_DAMAGE, (Object)maxDamage);
            stack.setData(DataComponentTypes.DAMAGE, (Object)template.getDamage());
        }
        if (template.getMaxStackSize() != null) {
            stack.setData(DataComponentTypes.MAX_STACK_SIZE, (Object)template.getMaxStackSize());
        }
        TooltipDisplay.Builder tooltipBuilder = TooltipDisplay.tooltipDisplay().hideTooltip(template.hasNoTooltip()).addHiddenComponents(new DataComponentType[]{DataComponentTypes.ENCHANTMENTS, DataComponentTypes.UNBREAKABLE, DataComponentTypes.DYED_COLOR, DataComponentTypes.STORED_ENCHANTMENTS, DataComponentTypes.PROVIDES_TRIM_MATERIAL, DataComponentTypes.BUNDLE_CONTENTS, DataComponentTypes.BLOCK_DATA, DataComponentTypes.POTION_CONTENTS, (DataComponentType)RegistryAccess.registryAccess().getRegistry(RegistryKey.DATA_COMPONENT_TYPE).get(DataComponentTypeKeys.BEES)});
        if (hideAttributes) {
            tooltipBuilder.addHiddenComponents(new DataComponentType[]{DataComponentTypes.ATTRIBUTE_MODIFIERS});
        }
        stack.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)tooltipBuilder.build()));
        ItemEnchantments.Builder enchantmentBuilder = ItemEnchantments.itemEnchantments();
        Map<Key, Integer> enchantments = template.getEnchantments();
        for (Key key : enchantments.keySet()) {
            Enchantment enchant = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(key);
            if (enchant == null) {
                ConsoleMessenger.bug("Invalid enchantment '" + String.valueOf(key) + "' cannot be put on an item", (Object)this);
                continue;
            }
            enchantmentBuilder.add(enchant, enchantments.get(key).intValue());
        }
        stack.setData(DataComponentTypes.ENCHANTMENTS, (DataComponentBuilder)enchantmentBuilder);
        if (template.getLeatherColor() != null) {
            stack.setData(DataComponentTypes.DYED_COLOR, (Object)DyedItemColor.dyedItemColor((Color)Color.fromRGB((int)template.getLeatherColor().value())));
        }
        stack.setData(DataComponentTypes.USE_COOLDOWN, (DataComponentBuilder)UseCooldown.useCooldown((float)1.0f).cooldownGroup(template.getCooldownGroup()));
        stack.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addString(template.getCustomModelData()).build()));
        if (template.getCompareKey() != null && (meta = stack.getItemMeta()) != null) {
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            PDCHelper.addStringToPdc(pdc, "compare_key", template.getCompareKey());
            stack.setItemMeta(meta);
        }
        StackHandlePaper handle = new StackHandlePaper(stack);
        if (template.getExtraData() != null) {
            handle.setStorage(template.getExtraData());
        }
        return handle;
    }
}

