/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.api.item;

import io.github.steaf23.bingoreloaded.lib.api.PlatformResolver;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataStorage;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public interface StackHandle {
    public ItemType type();

    public int amount();

    public Component customName();

    public List<Component> lore();

    public String compareKey();

    public boolean isTool();

    public boolean isArmor();

    public void setAmount(int var1);

    public StackHandle clone();

    public void setStorage(TagDataStorage var1);

    @NotNull
    public TagDataStorage getStorage();

    public void setCooldown(Key var1, double var2);

    public static StackHandle createFromTemplate(ItemTemplate template, boolean hideAttributes) {
        return PlatformResolver.get().createStackFromTemplate(template, hideAttributes);
    }

    public static StackHandle create(ItemType type, int amount) {
        return PlatformResolver.get().createStack(type, amount);
    }

    public static StackHandle create(ItemType type) {
        return PlatformResolver.get().createStack(type, 1);
    }

    public static StackHandle empty() {
        return PlatformResolver.get().createStack(ItemType.AIR, 1);
    }

    public static StackHandle deserializeBytes(byte[] bytes) {
        return PlatformResolver.get().createStackFromBytes(bytes);
    }

    public static byte[] serializeBytes(StackHandle stack) {
        return PlatformResolver.get().createBytesFromStack(stack);
    }
}

