/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.api.item;

import io.github.steaf23.bingoreloaded.lib.api.PlatformResolver;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataStorage;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagTree;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.util.PDCHelper;
import io.github.steaf23.bingoreloaded.util.ItemHelper;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.UseCooldown;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackHandlePaper
implements StackHandle {
    @NotNull
    private final ItemStack stack;
    private static final NamespacedKey CUSTOM_DATA_KEY = new NamespacedKey(PlatformResolver.get().getExtensionInfo().name().toLowerCase(), "custom");

    public StackHandlePaper(@Nullable ItemStack stack) {
        this.stack = stack != null ? stack : new ItemStack(Material.AIR);
    }

    @Override
    public ItemType type() {
        return new ItemTypePaper(this.stack.getType());
    }

    @Override
    public int amount() {
        return this.stack.getAmount();
    }

    @Override
    public Component customName() {
        return this.stack.getItemMeta().displayName();
    }

    @Override
    public List<Component> lore() {
        return this.stack.getItemMeta().lore();
    }

    @Override
    public String compareKey() {
        if (this.stack.getItemMeta() == null) {
            return "";
        }
        return PDCHelper.getStringFromPdc(this.stack.getItemMeta().getPersistentDataContainer(), "compare_key");
    }

    @Override
    public boolean isTool() {
        return ItemHelper.isTool(this.stack.getType());
    }

    @Override
    public boolean isArmor() {
        return ItemHelper.isArmor(this.stack.getType());
    }

    @Override
    public void setAmount(int newAmount) {
        this.stack.setAmount(newAmount);
    }

    @Override
    public StackHandle clone() {
        return new StackHandlePaper(this.stack.clone());
    }

    @Override
    public void setStorage(TagDataStorage newStorage) {
        this.stack.editPersistentDataContainer(container -> {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                newStorage.getTree().getPayload(out);
                byte[] bytes = out.toByteArray();
                container.set(CUSTOM_DATA_KEY, PersistentDataType.BYTE_ARRAY, (Object)bytes);
            }
            catch (IOException e) {
                ConsoleMessenger.bug("Custom Data (in setStorage()) exception", (Object)this);
                e.printStackTrace();
            }
        });
    }

    @Override
    @NotNull
    public TagDataStorage getStorage() {
        TagDataStorage tagDataStorage;
        byte[] bytes = (byte[])this.stack.getItemMeta().getPersistentDataContainer().get(CUSTOM_DATA_KEY, PersistentDataType.BYTE_ARRAY);
        if (bytes == null) {
            return new TagDataStorage();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            TagTree tree = TagTree.fromPayload(in);
            tagDataStorage = new TagDataStorage(tree);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                ConsoleMessenger.bug("Custom Data (in getStorage()) exception", (Object)this);
                e.printStackTrace();
                return new TagDataStorage();
            }
        }
        in.close();
        return tagDataStorage;
    }

    @Override
    public void setCooldown(Key cooldownGroup, double cooldownTimeSeconds) {
        this.stack.setData(DataComponentTypes.USE_COOLDOWN, (Object)((UseCooldown)UseCooldown.useCooldown((float)((float)cooldownTimeSeconds)).cooldownGroup(cooldownGroup).build()));
    }

    public ItemStack handle() {
        return this.stack;
    }
}

