/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.api.player;

import io.github.steaf23.bingoreloaded.lib.api.AdvancementHandle;
import io.github.steaf23.bingoreloaded.lib.api.AdvancementHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.EntityType;
import io.github.steaf23.bingoreloaded.lib.api.EntityTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.PaperApiHelper;
import io.github.steaf23.bingoreloaded.lib.api.PlayerGamemode;
import io.github.steaf23.bingoreloaded.lib.api.PotionEffectInstance;
import io.github.steaf23.bingoreloaded.lib.api.StatisticType;
import io.github.steaf23.bingoreloaded.lib.api.StatisticTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.StatusEffectTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.item.InventoryHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.InventoryHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerInventoryHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerInventoryHandlePaper;
import io.github.steaf23.bingoreloaded.lib.util.DebugLogger;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerHandlePaper
implements PlayerHandle {
    private final Player player;

    public PlayerHandlePaper(@NotNull Player player) {
        this.player = player;
    }

    @Override
    public String playerName() {
        return this.player.getName();
    }

    @Override
    public Component displayName() {
        return this.player.displayName();
    }

    @Override
    public UUID uniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public WorldHandle world() {
        return new WorldHandlePaper(this.player.getWorld());
    }

    @Override
    public WorldPosition position() {
        return PaperApiHelper.worldPosFromLocation(this.player.getLocation());
    }

    @Override
    @Nullable
    public WorldPosition respawnPoint() {
        return PaperApiHelper.worldPosFromLocation(this.player.getRespawnLocation());
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.player.hasPermission(permission);
    }

    @Override
    public int level() {
        return this.player.getLevel();
    }

    @Override
    public float exp() {
        return this.player.getExp();
    }

    @Override
    public double health() {
        return this.player.getHealth();
    }

    @Override
    public int foodLevel() {
        return this.player.getFoodLevel();
    }

    @Override
    public PlayerGamemode gamemode() {
        return PlayerHandlePaper.toPlayerMode(this.player.getGameMode());
    }

    @Override
    public int getStatisticValue(StatisticType type) {
        return this.player.getStatistic(((StatisticTypePaper)type).handle());
    }

    @Override
    public int getStatisticValue(StatisticType type, EntityType entity) {
        return this.player.getStatistic(((StatisticTypePaper)type).handle(), ((EntityTypePaper)entity).handle());
    }

    @Override
    public int getStatisticValue(StatisticType type, ItemType item) {
        return this.player.getStatistic(((StatisticTypePaper)type).handle(), ((ItemTypePaper)item).handle());
    }

    @Override
    public void teleportAsync(WorldPosition pos, @Nullable Consumer<Boolean> whenFinished) {
        DebugLogger.addLog("Teleporting player async to pos: " + pos.x() + ", " + pos.y() + ", " + pos.z() + ", world: " + pos.world().name());
        CompletableFuture future = this.player.teleportAsync(PaperApiHelper.locationFromWorldPos(pos), PlayerTeleportEvent.TeleportCause.PLUGIN);
        if (whenFinished != null) {
            future.thenAccept(whenFinished);
        }
    }

    @Override
    public boolean teleportBlocking(WorldPosition pos) {
        DebugLogger.addLog("Teleporting player blocking to pos: " + pos.x() + ", " + pos.y() + ", " + pos.z() + ", world: " + pos.world().name());
        return this.player.teleport(PaperApiHelper.locationFromWorldPos(pos), PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public PlayerInventoryHandle inventory() {
        return new PlayerInventoryHandlePaper(this.player.getInventory());
    }

    @Override
    public void clearInventory() {
        this.player.getInventory().clear();
    }

    @Override
    public void openInventory(InventoryHandle inventory) {
        this.player.openInventory(((InventoryHandlePaper)inventory).handle());
    }

    @Override
    public InventoryHandle enderChest() {
        return new InventoryHandlePaper(this.player.getEnderChest());
    }

    @Override
    public void setRespawnPoint(WorldPosition newSpawn, boolean force) {
        this.player.setRespawnLocation(PaperApiHelper.locationFromWorldPos(newSpawn), force);
    }

    @Override
    public void setLevel(int level) {
        this.player.setLevel(level);
    }

    @Override
    public void setExp(float exp) {
        this.player.setExp(exp);
    }

    @Override
    public void setFoodLevel(int foodLevel) {
        this.player.setFoodLevel(foodLevel);
    }

    @Override
    public void setHealth(double health) {
        this.player.setHealth(health);
    }

    @Override
    public void setGamemode(PlayerGamemode gamemode) {
        this.player.setGameMode(PlayerHandlePaper.fromPlayerMode(gamemode));
    }

    @Override
    public void setStatisticValue(StatisticType type, int value) {
        this.player.setStatistic(((StatisticTypePaper)type).handle(), value);
    }

    @Override
    public void setStatisticValue(StatisticType type, EntityType entity, int value) {
        this.player.setStatistic(((StatisticTypePaper)type).handle(), ((EntityTypePaper)entity).handle(), value);
    }

    @Override
    public void setStatisticValue(StatisticType type, ItemType item, int value) {
        this.player.setStatistic(((StatisticTypePaper)type).handle(), ((ItemTypePaper)item).handle(), value);
    }

    @Override
    public void addEffect(PotionEffectInstance effect) {
        this.player.addPotionEffect(new PotionEffect(((StatusEffectTypePaper)effect.effect()).handle(), effect.durationTicks(), effect.amplifier(), effect.ambient(), effect.particles(), effect.icon()));
    }

    public static GameMode fromPlayerMode(PlayerGamemode gamemode) {
        return switch (gamemode) {
            default -> throw new MatchException(null, null);
            case PlayerGamemode.SPECTATOR -> GameMode.SPECTATOR;
            case PlayerGamemode.CREATIVE -> GameMode.CREATIVE;
            case PlayerGamemode.SURVIVAL -> GameMode.SURVIVAL;
            case PlayerGamemode.ADVENTURE -> GameMode.ADVENTURE;
        };
    }

    public static PlayerGamemode toPlayerMode(GameMode gameMode) {
        return switch (gameMode) {
            default -> throw new MatchException(null, null);
            case GameMode.SURVIVAL -> PlayerGamemode.SURVIVAL;
            case GameMode.CREATIVE -> PlayerGamemode.CREATIVE;
            case GameMode.SPECTATOR -> PlayerGamemode.SPECTATOR;
            case GameMode.ADVENTURE -> PlayerGamemode.ADVENTURE;
        };
    }

    @Override
    public void clearAllEffects() {
        this.player.clearActivePotionEffects();
    }

    @Override
    public void removeAdvancementProgress(AdvancementHandle advancement) {
        AdvancementProgress progress = this.player.getAdvancementProgress(((AdvancementHandlePaper)advancement).handle());
        progress.getAwardedCriteria().forEach(arg_0 -> ((AdvancementProgress)progress).revokeCriteria(arg_0));
    }

    @Override
    public boolean hasCooldown(StackHandle stack) {
        return this.player.hasCooldown(((StackHandlePaper)stack).handle());
    }

    @Override
    public boolean hasCooldownOnGroup(Key cooldownGroup) {
        return this.player.getCooldown(cooldownGroup) > 0;
    }

    @Override
    public void setCooldown(StackHandle stack, int cooldownTicks) {
        this.player.setCooldown(((StackHandlePaper)stack).handle(), cooldownTicks);
    }

    @Override
    public void setCooldownOnGroup(Key cooldownGroup, int cooldownTicks) {
        this.player.setCooldown(cooldownGroup, cooldownTicks);
    }

    @Override
    public boolean isSneaking() {
        return this.player.isSneaking();
    }

    @Override
    public void closeInventory() {
        this.player.closeInventory();
    }

    @Override
    @NotNull
    public Iterable<? extends Audience> audiences() {
        return List.of(this.player);
    }

    public Player handle() {
        return this.player;
    }
}

