/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.data.core;

import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorageSerializer;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorageSerializerRegistry;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagAdapter;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataType;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataStorage {
    public DataStorage createNew();

    public Set<String> getKeys();

    public void setByte(String var1, byte var2);

    public byte getByte(String var1, byte var2);

    public void setShort(String var1, short var2);

    public short getShort(String var1, short var2);

    public void setInt(String var1, int var2);

    public int getInt(String var1, int var2);

    public void setLong(String var1, long var2);

    public long getLong(String var1, long var2);

    public void setString(String var1, @NotNull String var2);

    @NotNull
    public String getString(String var1, String var2);

    public <T> void setList(String var1, TagDataType<T> var2, List<T> var3);

    public <T> List<T> getList(String var1, TagDataType<T> var2);

    public <T> void setList(String var1, TagAdapter<T, ?> var2, List<T> var3);

    public <T> List<T> getList(String var1, TagAdapter<T, ?> var2);

    public <T> void setSerializableList(String var1, Class<T> var2, List<T> var3);

    public <T> List<T> getSerializableList(String var1, Class<T> var2);

    default public <T> void setSerializable(String path, Class<T> classType, @NotNull T value) {
        DataStorage storage = this.createNew();
        storage.fromSerializable(classType, value);
        this.setStorage(path, storage);
    }

    default public <T> void fromSerializable(Class<T> classType, @NotNull T value) {
        DataStorageSerializer<T> serializer = DataStorageSerializerRegistry.getSerializer(classType);
        if (serializer == null) {
            ConsoleMessenger.bug("No serializer registered for serialization " + String.valueOf(classType), (Object)this);
            return;
        }
        serializer.toDataStorage(this, value);
    }

    @Nullable
    default public <T> T getSerializable(String path, Class<T> classType) {
        return this.getSerializable(path, classType, null);
    }

    @NotNull
    default public <T> T getSerializable(String path, Class<T> classType, T def) {
        DataStorage serializable = this.getStorage(path);
        if (serializable == null) {
            return def;
        }
        T value = serializable.toSerializable(classType);
        return value == null ? def : value;
    }

    @Nullable
    default public <T> T toSerializable(Class<T> classType) {
        DataStorageSerializer<T> serializer = DataStorageSerializerRegistry.getSerializer(classType);
        if (serializer == null) {
            ConsoleMessenger.bug("No serializer registered for deserialization " + String.valueOf(classType), (Object)this);
            return null;
        }
        return serializer.fromDataStorage(this);
    }

    public void setBoolean(String var1, boolean var2);

    public boolean getBoolean(String var1);

    public boolean getBoolean(String var1, boolean var2);

    public void setFloat(String var1, float var2);

    public float getFloat(String var1, float var2);

    public void setDouble(String var1, double var2);

    public double getDouble(String var1, double var2);

    public void setItemStack(String var1, StackHandle var2);

    @NotNull
    public StackHandle getItemStack(String var1);

    public void setUUID(String var1, @Nullable UUID var2);

    @Nullable
    public UUID getUUID(String var1);

    public void setWorldPosition(String var1, @NotNull WorldPosition var2);

    @Nullable
    public WorldPosition getWorldPosition(String var1);

    @NotNull
    public WorldPosition getWorldPosition(String var1, @NotNull WorldPosition var2);

    public void setNamespacedKey(String var1, @NotNull Key var2);

    @NotNull
    public Key getNamespacedKey(String var1);

    public void setStorage(String var1, DataStorage var2);

    @Nullable
    public DataStorage getStorage(String var1);

    public void erase(String var1);

    public boolean contains(String var1);

    public void clear();
}

