/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.data.core;

import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorageSerializer;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.adapters.WorldPositionStorageSerializer;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class DataStorageSerializerRegistry {
    private static final Map<Class<?>, DataStorageSerializer<?>> serializers = new HashMap();

    public static <T> void addSerializer(DataStorageSerializer<T> serializer, Class<T> classType) {
        serializers.put(classType, serializer);
    }

    @Nullable
    public static <T> DataStorageSerializer<T> getSerializer(Class<T> classType) {
        if (!serializers.containsKey(classType)) {
            ConsoleMessenger.error("No data storage serializer registered for given class type " + classType.getName());
        }
        return serializers.get(classType);
    }

    static {
        DataStorageSerializerRegistry.addSerializer(new WorldPositionStorageSerializer(), WorldPosition.class);
    }
}

