/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.data.core;

import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.core.YamlDataStorage;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Paths;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlDataAccessor
extends YamlDataStorage
implements DataAccessor {
    private final ServerSoftware platform;
    private final String location;
    private final boolean internalOnly;

    public YamlDataAccessor(ServerSoftware platform, String location, boolean internalOnly) {
        super((ConfigurationSection)new YamlConfiguration());
        this.platform = platform;
        this.location = location;
        this.internalOnly = internalOnly;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getFileExtension() {
        return ".yml";
    }

    @Override
    public void load() {
        if (this.isInternalReadOnly()) {
            InputStream stream = this.platform.getResource(this.getLocation() + this.getFileExtension());
            if (stream != null) {
                this.config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream));
            }
            return;
        }
        File file = new File(this.platform.getDataFolder(), this.getLocation() + this.getFileExtension());
        if (!file.exists()) {
            this.platform.saveResource(Paths.get(this.getLocation() + this.getFileExtension(), new String[0]).toString(), false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)file);
        InputStream stream = this.platform.getResource(this.getLocation() + this.getFileExtension());
        if (stream != null) {
            YamlConfiguration defaultValues = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream));
            ((YamlConfiguration)this.config).setDefaults((Configuration)defaultValues);
        }
    }

    @Override
    public void saveChanges() {
        if (this.config == null || this.isInternalReadOnly()) {
            return;
        }
        try {
            ((YamlConfiguration)this.config).save(new File(this.platform.getDataFolder(), this.getLocation() + this.getFileExtension()));
        }
        catch (IOException e) {
            ConsoleMessenger.log(e.getMessage());
        }
    }

    @Override
    public boolean isInternalReadOnly() {
        return this.internalOnly;
    }
}

