/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.data.core;

import io.github.steaf23.bingoreloaded.lib.api.PaperApiHelper;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandlePaper;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorageSerializer;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorageSerializerRegistry;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagAdapter;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataType;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlDataStorage
implements DataStorage {
    protected ConfigurationSection config;

    public YamlDataStorage(ConfigurationSection config) {
        this.config = config;
    }

    public YamlDataStorage() {
        this.config = new YamlConfiguration();
    }

    @Override
    public DataStorage createNew() {
        return new YamlDataStorage();
    }

    @Override
    public Set<String> getKeys() {
        return this.config.getKeys(false);
    }

    @Override
    public void setByte(String path, byte value) {
        this.config.set(path, (Object)value);
    }

    @Override
    public byte getByte(String path, byte def) {
        return (byte)this.config.getInt(path, (int)def);
    }

    @Override
    public void setShort(String path, short value) {
        this.config.set(path, (Object)value);
    }

    @Override
    public short getShort(String path, short def) {
        return (short)this.config.getInt(path, (int)def);
    }

    @Override
    public void setInt(String path, int value) {
        this.config.set(path, (Object)value);
    }

    @Override
    public int getInt(String path, int def) {
        return this.config.getInt(path, def);
    }

    @Override
    public void setLong(String path, long value) {
        this.config.set(path, (Object)value);
    }

    @Override
    public long getLong(String path, long def) {
        return this.config.getLong(path, def);
    }

    @Override
    public void setString(String path, @NotNull String value) {
        this.config.set(path, (Object)value);
    }

    @Override
    @NotNull
    public String getString(String path, String def) {
        return this.config.getString(path, def);
    }

    @Override
    public <T> void setList(String path, TagDataType<T> type, List<T> values) {
        this.config.set(path, values);
    }

    @Override
    public <T> List<T> getList(String path, TagDataType<T> dataType) {
        try {
            return this.config.getList(path);
        }
        catch (ClassCastException castException) {
            return List.of();
        }
    }

    @Override
    public <T> void setList(String path, TagAdapter<T, ?> adapterType, List<T> values) {
        this.config.set(path, values);
    }

    @Override
    public <T> List<T> getList(String path, TagAdapter<T, ?> adapterType) {
        return this.getList(path, (TagDataType)null);
    }

    @Override
    public <T> void setSerializableList(String path, Class<T> dataType, List<T> values) {
        this.config.set(path, values.stream().map(v -> {
            YamlDataStorage storage = new YamlDataStorage();
            DataStorageSerializer<Object> serializer = DataStorageSerializerRegistry.getSerializer(dataType);
            if (serializer == null) {
                ConsoleMessenger.bug("No serializer registered for this type of data at path " + path, (Object)this);
                return storage.config;
            }
            serializer.toDataStorage(storage, v);
            return storage.config;
        }).toList());
    }

    @Override
    public <T> List<T> getSerializableList(String path, Class<T> dataType) {
        DataStorageSerializer serializer = DataStorageSerializerRegistry.getSerializer(dataType);
        if (serializer == null) {
            ConsoleMessenger.bug("No serializer registered for this type of data at path " + path, (Object)this);
            return List.of();
        }
        return this.config.getList(path, List.of()).stream().map(v -> serializer.fromDataStorage(new YamlDataStorage())).toList();
    }

    @Override
    public void setBoolean(String path, boolean value) {
        this.config.set(path, (Object)value);
    }

    @Override
    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        return this.config.getBoolean(path, def);
    }

    @Override
    public void setFloat(String path, float value) {
        this.config.set(path, (Object)Float.valueOf(value));
    }

    @Override
    public float getFloat(String path, float def) {
        return (float)this.config.getDouble(path, (double)def);
    }

    @Override
    public void setDouble(String path, double value) {
        this.config.set(path, (Object)value);
    }

    @Override
    public double getDouble(String path, double def) {
        return this.config.getDouble(path, def);
    }

    @Override
    public void setItemStack(String path, StackHandle value) {
        this.config.set(path, (Object)value);
    }

    @Override
    @NotNull
    public StackHandle getItemStack(String path) {
        return new StackHandlePaper(this.config.getItemStack(path, new ItemStack(Material.AIR)));
    }

    @Override
    public void setUUID(String path, UUID value) {
        this.config.set(path, (Object)value.toString());
    }

    @Override
    @Nullable
    public UUID getUUID(String path) {
        String uuidString = this.config.getString(path, "");
        if (uuidString.isEmpty()) {
            return null;
        }
        return UUID.fromString(uuidString);
    }

    @Override
    public void setWorldPosition(String path, @NotNull WorldPosition value) {
        this.config.set(path, (Object)value);
    }

    @Override
    @Nullable
    public WorldPosition getWorldPosition(String path) {
        Location loc = this.config.getLocation(path);
        return loc == null ? null : PaperApiHelper.worldPosFromLocation(loc);
    }

    @Override
    @NotNull
    public WorldPosition getWorldPosition(String path, @NotNull WorldPosition def) {
        WorldPosition pos = this.getWorldPosition(path);
        return pos == null ? def : pos;
    }

    @Override
    public void setNamespacedKey(String path, @NotNull Key value) {
        this.config.set(path, (Object)value);
    }

    @Override
    @NotNull
    public Key getNamespacedKey(String path) {
        Object ns = this.config.get(path);
        if (ns instanceof NamespacedKey) {
            NamespacedKey key = (NamespacedKey)ns;
            return key;
        }
        return new NamespacedKey("", "");
    }

    @Override
    public void setStorage(String path, DataStorage value) {
        if (!(value instanceof YamlDataStorage)) {
            ConsoleMessenger.bug("Cannot add data storage to file configuration storage, because it is of a different type!", (Object)this);
            return;
        }
        YamlDataStorage yamlDataStorage = (YamlDataStorage)value;
        this.config.set(path, (Object)yamlDataStorage.config);
    }

    @Override
    @Nullable
    public DataStorage getStorage(String path) {
        ConfigurationSection section = this.config.getConfigurationSection(path);
        if (section == null) {
            return null;
        }
        return new YamlDataStorage(section);
    }

    @Override
    public void erase(String path) {
        this.config.set(path, null);
    }

    @Override
    public boolean contains(String path) {
        return this.config.contains(path);
    }

    @Override
    public void clear() {
        this.config = new YamlConfiguration();
    }

    @NotNull
    public ConfigurationSection getSection() {
        return this.config;
    }

    public void setComment(String forKey, List<String> comments) {
        ConfigurationSection configurationSection = this.config;
        if (!(configurationSection instanceof YamlConfiguration)) {
            return;
        }
        YamlConfiguration yamlConfig = (YamlConfiguration)configurationSection;
        yamlConfig.setComments(forKey, comments);
    }
}

