/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.data.core.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.data.core.DataAccessor;
import io.github.steaf23.bingoreloaded.lib.data.core.json.JsonDataStorage;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.Tag;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataType;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagList;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagTree;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

public class JsonDataAccessor
extends JsonDataStorage
implements DataAccessor {
    private final ServerSoftware server;
    private final String filepath;
    private final boolean readOnly;

    public JsonDataAccessor(ServerSoftware server, String filepath, boolean readOnly) {
        this.server = server;
        this.filepath = filepath;
        this.readOnly = readOnly;
    }

    @Override
    public String getLocation() {
        return this.filepath;
    }

    @Override
    public String getFileExtension() {
        return ".json";
    }

    @Override
    public void load() {
        if (this.isInternalReadOnly()) {
            InputStream stream = this.server.getResource(this.getLocation() + this.getFileExtension());
            if (stream != null) {
                JsonDataAccessor.readJsonFromFile(this, stream);
            }
            return;
        }
        File file = new File(this.server.getDataFolder(), this.getLocation() + this.getFileExtension());
        if (!file.exists()) {
            this.server.saveResource(this.getLocation() + this.getFileExtension(), false);
        }
        try (FileInputStream input = new FileInputStream(file);){
            JsonDataAccessor.readJsonFromFile(this, input);
        }
        catch (IOException e) {
            ConsoleMessenger.bug("Could not open json file for reading", (Object)this);
        }
    }

    @Override
    public void saveChanges() {
        if (this.isInternalReadOnly()) {
            return;
        }
        ConsoleMessenger.error("Writing json files from JsonDataAccessor is not implemented yet!");
    }

    @Override
    public boolean isInternalReadOnly() {
        return this.readOnly;
    }

    public static void readJsonFromFile(JsonDataStorage storage, InputStream input) {
        storage.clear();
        JsonElement element = JsonParser.parseReader(new InputStreamReader(input));
        Tag<?> nbt = JsonDataAccessor.toTag(element);
        if (nbt.getType() != TagDataType.COMPOUND) {
            return;
        }
        storage.setTree((TagTree)nbt.getValue());
    }

    private static Tag<?> toTag(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isBoolean()) {
                return TagDataType.BOOLEAN.toTag(jsonPrimitive.getAsBoolean());
            }
            if (jsonPrimitive.isNumber()) {
                Number number = jsonPrimitive.getAsNumber();
                long longVal = number.longValue();
                int intVal = number.intValue();
                double doubleVal = number.doubleValue();
                if (Math.abs((double)longVal - doubleVal) > 1.0E-6) {
                    return new Tag.DoubleTag(doubleVal);
                }
                if ((long)intVal != longVal) {
                    return new Tag.LongTag(longVal);
                }
                return new Tag.IntegerTag(intVal);
            }
            if (jsonPrimitive.isString()) {
                return new Tag.StringTag(jsonPrimitive.getAsString());
            }
        } else {
            if (jsonElement.isJsonArray()) {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                TagList data = new TagList();
                try {
                    for (JsonElement element : jsonArray) {
                        data.addTag(JsonDataAccessor.toTag(element));
                    }
                }
                catch (IllegalArgumentException ex) {
                    ConsoleMessenger.bug("Cannot convert json to NBT using different types within the same list.", JsonDataAccessor.class);
                }
                return new Tag.ListTag(data);
            }
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                TagTree nbtCompound = new TagTree();
                for (Map.Entry<String, JsonElement> jsonEntry : jsonObject.entrySet()) {
                    nbtCompound.putChild(jsonEntry.getKey(), JsonDataAccessor.toTag(jsonEntry.getValue()));
                }
                return new Tag.CompoundTag(nbtCompound);
            }
        }
        ConsoleMessenger.bug("Cannot convert json to NBT, invalid data found.", JsonDataAccessor.class);
        return new Tag.CompoundTag(new TagTree());
    }
}

