/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.data.core.node;

import java.util.Arrays;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class NodeLikeData {
    public static <T extends Node> void setNested(NodeBranch<T> root, String key, T value, Supplier<NodeBranch<T>> subNodeSupplier) {
        NodeBranch subNode;
        String[] fullPath = Arrays.stream(key.split("\\.")).filter(s -> !s.isEmpty()).toList().toArray(new String[0]);
        if (fullPath.length == 0) {
            return;
        }
        if (fullPath.length == 1) {
            root.putData(fullPath[0], (NodeBranch)value);
            return;
        }
        T data = root.getData(fullPath[0]);
        if (data instanceof NodeBranch) {
            NodeBranch branch;
            subNode = branch = (NodeBranch)data;
        } else {
            subNode = subNodeSupplier.get();
            root.putData(fullPath[0], subNode);
        }
        NodeLikeData.setNested(subNode, key.substring(fullPath[0].length() + 1), value, subNodeSupplier);
    }

    @Nullable
    public static <T extends Node> T getNested(NodeBranch<T> root, String key) {
        NodeBranch branch;
        String[] fullPath = Arrays.stream(key.split("\\.")).filter(s -> !s.isEmpty()).toList().toArray(new String[0]);
        if (fullPath.length == 0) {
            return null;
        }
        if (fullPath.length == 1) {
            return root.getData(fullPath[0]);
        }
        T data = root.getData(fullPath[0]);
        if (!(data instanceof NodeBranch)) {
            return null;
        }
        NodeBranch subNode = branch = (NodeBranch)data;
        return NodeLikeData.getNested(subNode, key.substring(fullPath[0].length() + 1));
    }

    public static <T extends Node> void removeNested(NodeBranch<T> root, String key) {
        String[] fullPath = Arrays.stream(key.split("\\.")).filter(s -> !s.isEmpty()).toList().toArray(new String[0]);
        if (fullPath.length == 0) {
            return;
        }
        if (fullPath.length == 1) {
            root.removeData(fullPath[0]);
            return;
        }
        T data = root.getData(fullPath[0]);
        if (data instanceof NodeBranch) {
            NodeBranch branch = (NodeBranch)data;
            NodeLikeData.removeNested(branch, key.substring(fullPath[0].length() + 1));
        } else {
            root.removeData(fullPath[0]);
        }
    }

    public static <T extends Node> boolean containsFullPath(NodeBranch<T> root, String key) {
        NodeBranch branch;
        String[] fullPath = Arrays.stream(key.split("\\.")).filter(s -> !s.isEmpty()).toList().toArray(new String[0]);
        if (fullPath.length == 0) {
            return false;
        }
        if (fullPath.length == 1) {
            return root.contains(fullPath[0]);
        }
        T data = root.getData(fullPath[0]);
        if (!(data instanceof NodeBranch)) {
            return false;
        }
        NodeBranch subNode = branch = (NodeBranch)data;
        return NodeLikeData.containsFullPath(subNode, key.substring(fullPath[0].length() + 1));
    }

    public static interface NodeBranch<T extends Node>
    extends Node {
        @Nullable
        public T getData(String var1);

        public void putData(String var1, @Nullable T var2);

        public void removeData(String var1);

        public boolean contains(String var1);

        public boolean isEmpty();
    }

    public static interface Node {
    }
}

