/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.data.core.tag;

import io.github.steaf23.bingoreloaded.lib.data.core.node.NodeLikeData;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataType;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagList;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagTree;
import java.io.ByteArrayOutputStream;
import org.jetbrains.annotations.Nullable;

public interface Tag<T>
extends NodeLikeData.Node {
    public TagDataType<T> getType();

    public T getValue();

    default public void writePayloadBytes(ByteArrayOutputStream stream) {
        this.getType().writeBytes(this.getValue(), stream);
    }

    public record LongArrayTag(long[] data) implements Tag<long[]>
    {
        @Override
        public TagDataType<long[]> getType() {
            return TagDataType.LONG_ARRAY;
        }

        @Override
        public long[] getValue() {
            return this.data;
        }
    }

    public record IntegerArrayTag(int[] data) implements Tag<int[]>
    {
        @Override
        public TagDataType<int[]> getType() {
            return TagDataType.INT_ARRAY;
        }

        @Override
        public int[] getValue() {
            return this.data;
        }
    }

    public record ByteArrayTag(byte[] data) implements Tag<byte[]>
    {
        @Override
        public TagDataType<byte[]> getType() {
            return TagDataType.BYTE_ARRAY;
        }

        @Override
        public byte[] getValue() {
            return this.data;
        }
    }

    public record CompoundTag(TagTree data) implements Tag<TagTree>,
    NodeLikeData.NodeBranch<Tag<?>>
    {
        @Override
        public TagDataType<TagTree> getType() {
            return TagDataType.COMPOUND;
        }

        @Override
        public TagTree getValue() {
            return this.data;
        }

        @Override
        @Nullable
        public Tag<?> getData(String path) {
            return this.data.getChild(path);
        }

        @Override
        public void putData(String path, @Nullable Tag<?> newData) {
            this.data.putChild(path, newData);
        }

        @Override
        public void removeData(String path) {
            this.data.removeChild(path);
        }

        @Override
        public boolean contains(String path) {
            return this.data.containsChild(path);
        }

        @Override
        public boolean isEmpty() {
            return this.data.isEmpty();
        }
    }

    public record ListTag(TagList data) implements Tag<TagList>
    {
        @Override
        public TagDataType<TagList> getType() {
            return TagDataType.LIST;
        }

        @Override
        public TagList getValue() {
            return this.data;
        }
    }

    public record StringTag(String value) implements Tag<String>
    {
        @Override
        public TagDataType<String> getType() {
            return TagDataType.STRING;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public record DoubleTag(double value) implements Tag<Double>
    {
        @Override
        public TagDataType<Double> getType() {
            return TagDataType.DOUBLE;
        }

        @Override
        public Double getValue() {
            return this.value;
        }
    }

    public record FloatTag(float value) implements Tag<Float>
    {
        @Override
        public TagDataType<Float> getType() {
            return TagDataType.FLOAT;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }
    }

    public record LongTag(long value) implements Tag<Long>
    {
        @Override
        public TagDataType<Long> getType() {
            return TagDataType.LONG;
        }

        @Override
        public Long getValue() {
            return this.value;
        }
    }

    public record IntegerTag(int value) implements Tag<Integer>
    {
        @Override
        public TagDataType<Integer> getType() {
            return TagDataType.INT;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }
    }

    public record ShortTag(short value) implements Tag<Short>
    {
        @Override
        public TagDataType<Short> getType() {
            return TagDataType.SHORT;
        }

        @Override
        public Short getValue() {
            return this.value;
        }
    }

    public record ByteTag(byte value) implements Tag<Byte>
    {
        @Override
        public TagDataType<Byte> getType() {
            return TagDataType.BYTE;
        }

        @Override
        public Byte getValue() {
            return this.value;
        }
    }
}

