/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.data.core.tag;

import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorageSerializer;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorageSerializerRegistry;
import io.github.steaf23.bingoreloaded.lib.data.core.node.NodeLikeData;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.Tag;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagAdapter;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataType;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagList;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagTree;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagDataStorage
implements DataStorage {
    private Tag.CompoundTag root;

    public TagDataStorage() {
        this(new Tag.CompoundTag(new TagTree()));
    }

    public TagDataStorage(Tag.CompoundTag rootTag) {
        this.root = rootTag;
    }

    public TagDataStorage(TagTree tree) {
        this.root = new Tag.CompoundTag(tree);
    }

    @Override
    public TagDataStorage createNew() {
        return new TagDataStorage();
    }

    @Override
    public Set<String> getKeys() {
        return this.root.getValue().getKeys();
    }

    @Override
    public void setByte(String path, byte value) {
        this.set(path, TagDataType.BYTE.createTag(value));
    }

    @Override
    public byte getByte(String path, byte def) {
        Tag<?> tag = this.get(path);
        if (tag != null && tag.getType() == TagDataType.BYTE) {
            return (Byte)tag.getValue();
        }
        return def;
    }

    @Override
    public void setShort(String path, short value) {
        this.set(path, TagDataType.SHORT.createTag(value));
    }

    @Override
    public short getShort(String path, short def) {
        Tag<?> tag = this.get(path);
        if (tag != null && tag.getType() == TagDataType.SHORT) {
            return (Short)tag.getValue();
        }
        return def;
    }

    @Override
    public void setInt(String path, int value) {
        this.set(path, new Tag.IntegerTag(value));
    }

    @Override
    public int getInt(String path, int def) {
        Tag<?> tag = this.get(path);
        if (tag != null && tag.getType() == TagDataType.INT) {
            return (Integer)tag.getValue();
        }
        return def;
    }

    @Override
    public void setLong(String path, long value) {
        this.set(path, TagDataType.LONG.createTag(value));
    }

    @Override
    public long getLong(String path, long def) {
        Tag<?> tag = this.get(path);
        if (tag != null && tag.getType() == TagDataType.LONG) {
            return (Long)tag.getValue();
        }
        return def;
    }

    @Override
    public void setString(String path, @NotNull String value) {
        this.set(path, TagDataType.STRING.createTag(value));
    }

    @Override
    @NotNull
    public String getString(String path, String def) {
        Tag<?> tag = this.get(path);
        if (tag != null && tag.getType() == TagDataType.STRING) {
            return (String)tag.getValue();
        }
        return def;
    }

    @Override
    public <T> void setList(String path, TagDataType<T> type, List<T> values) {
        if (type == TagDataType.BYTE) {
            byte[] bytes = new byte[values.size()];
            int i = 0;
            for (T value : values) {
                bytes[i] = (Byte)value;
                ++i;
            }
            this.set(path, new Tag.ByteArrayTag(bytes));
            return;
        }
        if (type == TagDataType.INT) {
            int[] ints = new int[values.size()];
            int i = 0;
            for (T value : values) {
                ints[i] = (Integer)value;
                ++i;
            }
            this.set(path, new Tag.IntegerArrayTag(ints));
            return;
        }
        if (type == TagDataType.LONG) {
            long[] longs = new long[values.size()];
            int i = 0;
            for (T value : values) {
                longs[i] = (Long)value;
                ++i;
            }
            this.set(path, new Tag.LongArrayTag(longs));
            return;
        }
        TagList tags = new TagList();
        for (T v : values) {
            tags.addTag(type.createTag(v));
        }
        this.set(path, TagDataType.LIST.createTag(tags));
    }

    @Override
    public <T> List<T> getList(String path, TagDataType<T> dataType) {
        Tag<?> tag = this.get(path);
        if (tag == null) {
            return List.of();
        }
        if (tag.getType() == TagDataType.LIST) {
            TagList tagList = (TagList)tag.getValue();
            return tagList.getList(dataType);
        }
        if (tag.getType() == TagDataType.BYTE_ARRAY) {
            if (tag instanceof Tag.ByteArrayTag) {
                Tag.ByteArrayTag arrTag = (Tag.ByteArrayTag)tag;
                ArrayList<Byte> result = new ArrayList<Byte>();
                byte[] byArray = arrTag.getValue();
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    Byte t;
                    Byte v = t = Byte.valueOf(byArray[i]);
                    result.add(v);
                }
                return result;
            }
            return List.of();
        }
        if (tag.getType() == TagDataType.INT_ARRAY) {
            if (tag instanceof Tag.IntegerArrayTag) {
                Tag.IntegerArrayTag arrTag = (Tag.IntegerArrayTag)tag;
                ArrayList<Integer> result = new ArrayList<Integer>();
                int[] nArray = arrTag.getValue();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer t;
                    Integer v = t = Integer.valueOf(nArray[i]);
                    result.add(v);
                }
                return result;
            }
            return List.of();
        }
        if (tag.getType() == TagDataType.LONG_ARRAY) {
            if (tag instanceof Tag.LongArrayTag) {
                Tag.LongArrayTag arrTag = (Tag.LongArrayTag)tag;
                ArrayList<Long> result = new ArrayList<Long>();
                long[] lArray = arrTag.getValue();
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long t;
                    Long v = t = Long.valueOf(lArray[i]);
                    result.add(v);
                }
                return result;
            }
            return List.of();
        }
        return List.of();
    }

    @Override
    public <T> void setList(String path, TagAdapter<T, ?> adapterType, List<T> values) {
        if (adapterType.getBaseType() == TagDataType.BYTE) {
            byte[] bytes = new byte[values.size()];
            int i = 0;
            for (T value : values) {
                bytes[i] = (Byte)adapterType.toTag(value).getValue();
                ++i;
            }
            this.set(path, TagDataType.BYTE_ARRAY.createTag(bytes));
            return;
        }
        if (adapterType.getBaseType() == TagDataType.INT) {
            int[] ints = new int[values.size()];
            int i = 0;
            for (T value : values) {
                ints[i] = (Integer)adapterType.toTag(value).getValue();
                ++i;
            }
            this.set(path, TagDataType.INT_ARRAY.createTag(ints));
            return;
        }
        if (adapterType.getBaseType() == TagDataType.LONG) {
            long[] longs = new long[values.size()];
            int i = 0;
            for (T value : values) {
                longs[i] = ((Integer)adapterType.toTag(value).getValue()).intValue();
                ++i;
            }
            this.set(path, TagDataType.LONG_ARRAY.createTag(longs));
            return;
        }
        TagList tags = new TagList();
        for (T v : values) {
            tags.addTag(adapterType.toTag(v));
        }
        this.set(path, TagDataType.LIST.createTag(tags));
    }

    @Override
    public <T> List<T> getList(String path, TagAdapter<T, ?> adapterType) {
        Tag<?> tag = this.get(path);
        if (tag == null) {
            return List.of();
        }
        if (tag.getType() == TagDataType.LIST) {
            TagList tagList = (TagList)tag.getValue();
            return tagList.getTags().stream().map(adapterType::fromTagOrNull).toList();
        }
        if (tag.getType() == TagDataType.BYTE_ARRAY) {
            byte[] values = (byte[])tag.getValue();
            ArrayList<T> result = new ArrayList<T>();
            for (byte v : values) {
                result.add(adapterType.fromTagOrNull(new Tag.ByteTag(v)));
            }
            return result;
        }
        if (tag.getType() == TagDataType.INT_ARRAY) {
            int[] values = (int[])tag.getValue();
            ArrayList<T> result = new ArrayList<T>();
            for (int v : values) {
                result.add(adapterType.fromTagOrNull(new Tag.IntegerTag(v)));
            }
            return result;
        }
        if (tag.getType() == TagDataType.LONG_ARRAY) {
            long[] values = (long[])tag.getValue();
            ArrayList<T> result = new ArrayList<T>();
            for (long v : values) {
                result.add(adapterType.fromTagOrNull(new Tag.LongTag(v)));
            }
            return result;
        }
        return List.of();
    }

    @Override
    public <T> void setSerializableList(String path, Class<T> classType, List<T> values) {
        this.setList(path, TagDataType.COMPOUND, values.stream().map(v -> {
            TagDataStorage storage = new TagDataStorage();
            DataStorageSerializer<Object> serializer = DataStorageSerializerRegistry.getSerializer(classType);
            if (serializer == null) {
                return storage.root.getValue();
            }
            serializer.toDataStorage(storage, v);
            return storage.root.getValue();
        }).toList());
    }

    @Override
    public <T> List<T> getSerializableList(String path, Class<T> classType) {
        DataStorageSerializer serializer = DataStorageSerializerRegistry.getSerializer(classType);
        if (serializer == null) {
            ConsoleMessenger.bug("No serializer registered for this type of data at path " + path, (Object)this);
            return List.of();
        }
        return this.getList(path, TagDataType.COMPOUND).stream().map(v -> serializer.fromDataStorage(new TagDataStorage(new Tag.CompoundTag((TagTree)v)))).toList();
    }

    @Override
    public void setBoolean(String path, boolean value) {
        this.set(path, TagDataType.BOOLEAN.toTag(value));
    }

    @Override
    public boolean getBoolean(String path) {
        Boolean bool = TagDataType.BOOLEAN.fromTagOrNull(this.get(path));
        return bool != null ? bool : false;
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        Boolean bool = TagDataType.BOOLEAN.fromTagOrNull(this.get(path));
        return bool != null ? bool : def;
    }

    @Override
    public void setFloat(String path, float value) {
        this.set(path, TagDataType.FLOAT.createTag(Float.valueOf(value)));
    }

    @Override
    public float getFloat(String path, float def) {
        Tag<?> tag = this.get(path);
        if (tag != null && tag.getType() == TagDataType.FLOAT) {
            return ((Float)tag.getValue()).floatValue();
        }
        return def;
    }

    @Override
    public void setDouble(String path, double value) {
        this.set(path, TagDataType.DOUBLE.createTag(value));
    }

    @Override
    public double getDouble(String path, double def) {
        Tag<?> tag = this.get(path);
        if (tag != null && tag.getType() == TagDataType.DOUBLE) {
            return (Double)tag.getValue();
        }
        return def;
    }

    @Override
    public void setItemStack(String path, StackHandle value) {
        this.set(path, TagDataType.ITEM_STACK.toTag(value));
    }

    @Override
    @NotNull
    public StackHandle getItemStack(String path) {
        StackHandle stack = TagDataType.ITEM_STACK.fromTagOrNull(this.get(path));
        return stack == null ? StackHandle.create(ItemType.AIR) : stack;
    }

    @Override
    public void setUUID(String path, @Nullable UUID value) {
        if (value == null) {
            return;
        }
        this.set(path, TagDataType.UUID.toTag(value));
    }

    @Override
    @Nullable
    public UUID getUUID(String path) {
        return TagDataType.UUID.fromTagOrNull(this.get(path));
    }

    @Override
    public void setWorldPosition(String path, @NotNull WorldPosition value) {
        this.setSerializable(path, WorldPosition.class, value);
    }

    @Override
    @Nullable
    public WorldPosition getWorldPosition(String path) {
        return this.getSerializable(path, WorldPosition.class);
    }

    @Override
    @NotNull
    public WorldPosition getWorldPosition(String path, @NotNull WorldPosition def) {
        WorldPosition loc = this.getSerializable(path, WorldPosition.class);
        return loc == null ? def : loc;
    }

    @Override
    public void setNamespacedKey(String path, @NotNull Key value) {
        this.setString(path, value.toString());
    }

    @Override
    @NotNull
    public Key getNamespacedKey(String path) {
        String stringified = this.getString(path, "");
        if (!stringified.isEmpty()) {
            return Key.key(stringified);
        }
        ConsoleMessenger.bug("Could not read namespaced key: '" + stringified + "'", this.getClass());
        assert (false);
        return Key.key("", "");
    }

    @Override
    public void setStorage(String path, DataStorage value) {
        if (!(value instanceof TagDataStorage)) {
            ConsoleMessenger.bug("Cannot add data storage to tag storage, because it is of a different type!", (Object)this);
            return;
        }
        TagDataStorage tagStorage = (TagDataStorage)value;
        this.set(path, tagStorage.root);
    }

    @Override
    @Nullable
    public DataStorage getStorage(String path) {
        Tag<?> tag = this.get(path);
        if (tag == null) {
            return null;
        }
        if (tag.getType() != TagDataType.COMPOUND) {
            return null;
        }
        return new TagDataStorage((Tag.CompoundTag)tag);
    }

    @Override
    public void erase(String path) {
        NodeLikeData.removeNested(this.root, path);
    }

    @Override
    public boolean contains(String path) {
        return NodeLikeData.containsFullPath(this.root, path);
    }

    @Override
    public void clear() {
        this.root = new Tag.CompoundTag(new TagTree());
    }

    public TagTree getTree() {
        return this.root.getValue();
    }

    public void setTree(TagTree tree) {
        this.root = new Tag.CompoundTag(tree);
    }

    @Nullable
    private Tag<?> get(String path) {
        return (Tag)NodeLikeData.getNested(this.root, path);
    }

    private void set(String key, Tag<?> tag) {
        NodeLikeData.setNested(this.root, key, tag, () -> new Tag.CompoundTag(new TagTree()));
    }
}

