/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.data.core.tag;

import io.github.steaf23.bingoreloaded.lib.data.core.tag.ByteHelper;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.Tag;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

public class TagList {
    TagDataType<?> tagType = TagDataType.BYTE;
    private final List<Tag<?>> tags = new ArrayList();

    public void addTag(Tag<?> tag) throws IllegalArgumentException {
        if (this.tags.isEmpty()) {
            this.tagType = tag.getType();
        }
        if (!this.tagType.equals(tag.getType())) {
            throw new IllegalArgumentException("Cannot add tag with different type to a list of a specified type!");
        }
        this.tags.add(tag);
    }

    public void removeTag(int index) {
        this.tags.remove(index);
    }

    public Tag<?> getTag(int index) {
        return this.tags.get(index);
    }

    public int size() {
        return this.tags.size();
    }

    public void getPayload(ByteArrayOutputStream stream) {
        stream.write(this.tagType.getId());
        stream.writeBytes(ByteHelper.intToBytes(this.tags.size()));
        for (Tag<?> t : this.tags) {
            t.writePayloadBytes(stream);
        }
    }

    public static TagList fromPayload(ByteArrayInputStream stream) {
        TagDataType<?> type = TagDataType.getTypeFromId(stream.read());
        if (type == null) {
            ByteHelper.readInt(stream);
            return new TagList();
        }
        int size = ByteHelper.readInt(stream);
        TagList list = new TagList();
        for (int i = 0; i < size; ++i) {
            list.addTag(type.createTagFromStream(stream));
        }
        return list;
    }

    public <T> List<T> getList(TagDataType<T> type) {
        if (type != this.tagType) {
            return List.of();
        }
        ArrayList result = new ArrayList();
        for (Tag<?> t : this.tags) {
            result.add(t.getValue());
        }
        return result;
    }

    public List<Tag<?>> getTags() {
        return this.tags;
    }
}

