/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.data.core.tag;

import io.github.steaf23.bingoreloaded.lib.data.core.tag.ByteHelper;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.Tag;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataType;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TagTree {
    private final Map<String, Tag<?>> tags = new HashMap();

    public Set<String> getKeys() {
        return this.tags.keySet();
    }

    public Tag<?> getChild(String path) {
        return this.tags.get(path);
    }

    public void putChild(String path, Tag<?> data) {
        if (data == null) {
            this.tags.remove(path);
            return;
        }
        this.tags.put(path, data);
    }

    public void removeChild(String path) {
        this.tags.remove(path);
    }

    public boolean containsChild(String path) {
        return this.tags.containsKey(path);
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    public void getPayload(ByteArrayOutputStream stream) {
        for (String name : this.getKeys()) {
            Tag<?> tag = this.tags.get(name);
            stream.write(tag.getType().getId());
            ByteHelper.writeString(name, stream);
            tag.writePayloadBytes(stream);
        }
        stream.write(0);
    }

    public static TagTree fromPayload(ByteArrayInputStream stream) {
        TagTree tree = new TagTree();
        byte id = (byte)stream.read();
        while (id != 0) {
            String name = ByteHelper.readString(stream);
            TagDataType<?> type = TagDataType.getTypeFromId(id);
            if (type == null) {
                ConsoleMessenger.error("Error while decoding NBT input stream");
                return null;
            }
            tree.putChild(name, type.createTagFromStream(stream));
            id = (byte)stream.read();
        }
        return tree;
    }
}

