/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.data.core.tag.adapters;

import io.github.steaf23.bingoreloaded.lib.api.PlatformResolver;
import io.github.steaf23.bingoreloaded.lib.api.WorldHandle;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorageSerializer;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class WorldPositionStorageSerializer
implements DataStorageSerializer<WorldPosition> {
    @Override
    public void toDataStorage(@NotNull DataStorage storage, @NotNull WorldPosition value) {
        storage.setUUID("world", value.world().uniqueId());
        storage.setDouble("x", value.x());
        storage.setDouble("y", value.y());
        storage.setDouble("z", value.z());
    }

    @Override
    public WorldPosition fromDataStorage(@NotNull DataStorage storage) {
        UUID id = storage.getUUID("world");
        if (id == null) {
            return null;
        }
        WorldHandle world = PlatformResolver.get().getWorld(id);
        if (world == null) {
            return null;
        }
        double x = storage.getDouble("x", 0.0);
        double y = storage.getDouble("y", 0.0);
        double z = storage.getDouble("z", 0.0);
        float yaw = storage.getFloat("yaw", 0.0f);
        float pitch = storage.getFloat("pitch", 0.0f);
        return new WorldPosition(world, x, y, z);
    }
}

