/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.events;

import io.github.steaf23.bingoreloaded.lib.api.AdvancementHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.InteractAction;
import io.github.steaf23.bingoreloaded.lib.api.PaperApiHelper;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandlePaper;
import io.github.steaf23.bingoreloaded.lib.event.EventResult;
import io.github.steaf23.bingoreloaded.lib.event.EventResults;
import io.github.steaf23.bingoreloaded.lib.event.PlatformEventDispatcher;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EventListenerPaper
implements Listener {
    private final JavaPlugin plugin;
    private final PlatformEventDispatcher dispatcher;

    public EventListenerPaper(JavaPlugin plugin, PlatformEventDispatcher dispatcher) {
        this.plugin = plugin;
        this.dispatcher = dispatcher;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void handlePlayerMoveEvent(PlayerMoveEvent event) {
        EventResult<?> result = this.dispatcher.sendPlayerMove(new PlayerHandlePaper(event.getPlayer()), PaperApiHelper.worldPosFromLocation(event.getFrom()), PaperApiHelper.worldPosFromLocation(event.getTo()));
        if (!result.cancel()) {
            return;
        }
        Location newLoc = event.getTo();
        newLoc.setX(event.getFrom().getX());
        newLoc.setZ(event.getFrom().getZ());
        event.setTo(newLoc);
    }

    @EventHandler
    public void handlePlayerDeathEvent(PlayerDeathEvent event) {
        List<StackHandlePaper> drops = event.getDrops().stream().map(StackHandlePaper::new).toList();
        EventResult<EventResults.PlayerDeathResult> result = this.dispatcher.sendPlayerDeath(new PlayerHandlePaper(event.getPlayer()), drops);
        event.getDrops().clear();
        if (result.data() == null || !result.data().keepInventory()) {
            event.getDrops().addAll(drops.stream().map(s -> ((StackHandlePaper)s).handle()).toList());
        } else {
            event.setKeepInventory(true);
        }
        event.setCancelled(result.cancel());
    }

    @EventHandler
    public void handlePlayerRespawnEvent(PlayerRespawnEvent event) {
        EventResult<EventResults.PlayerRespawnResult> result = this.dispatcher.sendPlayerRespawn(new PlayerHandlePaper(event.getPlayer()), event.isBedSpawn(), event.isAnchorSpawn());
        EventResults.PlayerRespawnResult data = result.data();
        if (data != null && data.overwriteSpawnPoint()) {
            if (data.newSpawnPoint() == null) {
                ConsoleMessenger.bug("New spawnpoint cannot be null when respawing player!", (Object)this);
                return;
            }
            event.setRespawnLocation(PaperApiHelper.locationFromWorldPos(data.newSpawnPoint()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void handlePlayerTeleportEvent(PlayerTeleportEvent event) {
        EventResult<?> result = this.dispatcher.sendPlayerTeleport(new PlayerHandlePaper(event.getPlayer()), PaperApiHelper.worldPosFromLocation(event.getFrom()), PaperApiHelper.worldPosFromLocation(event.getTo()));
        if (result.cancel()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handlePlayerPortalEvent(PlayerPortalEvent event) {
        EventResult<EventResults.PlayerMoveResult> result = this.dispatcher.sendPlayerPortal(new PlayerHandlePaper(event.getPlayer()), PaperApiHelper.worldPosFromLocation(event.getFrom()), PaperApiHelper.worldPosFromLocation(event.getTo()));
        if (result.cancel()) {
            event.setCancelled(true);
        }
        if (result.data() == null) {
            return;
        }
        if (!result.data().overwritePosition() || result.data().newPosition() == null) {
            return;
        }
        event.setTo(PaperApiHelper.locationFromWorldPos(result.data().newPosition()));
    }

    @EventHandler
    public void handlePlayerDroppedStackEvent(PlayerDropItemEvent event) {
        EventResult<?> result = this.dispatcher.sendPlayerDroppedStack(new PlayerHandlePaper(event.getPlayer()), new StackHandlePaper(event.getItemDrop().getItemStack()));
        if (result.cancel()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handlePlayerItemDamaged(PlayerItemDamageEvent event) {
        EventResult<?> result = this.dispatcher.sendPlayerStackDamaged(new PlayerHandlePaper(event.getPlayer()), new StackHandlePaper(event.getItem()));
        if (result.cancel()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handlePlayerInteracted(PlayerInteractEvent event) {
        if (event.getClickedBlock() != null && event.getClickedBlock().getType().isInteractable()) {
            return;
        }
        EventResult<?> result = this.dispatcher.sendPlayerInteracted(new PlayerHandlePaper(event.getPlayer()), new StackHandlePaper(event.getItem()), new InteractAction(event.getAction().isLeftClick(), event.getAction().isRightClick(), event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_AIR));
        if (result.cancel()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handlePlayerDamageEvent(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        EventResult<?> result = this.dispatcher.sendPlayerFallDamage(new PlayerHandlePaper(player));
        if (result.cancel()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handlePlayerJoinEvent(PlayerJoinEvent event) {
        this.dispatcher.sendPlayerJoinsServer(new PlayerHandlePaper(event.getPlayer()));
    }

    @EventHandler
    public void handlePlayerQuitEvent(PlayerQuitEvent event) {
        this.dispatcher.sendPlayerQuitsServer(new PlayerHandlePaper(event.getPlayer()));
    }

    @EventHandler
    public void handlePlayerBreakBlockEvent(BlockBreakEvent event) {
        EventResult<?> result = this.dispatcher.sendPlayerBreaksBlock(new PlayerHandlePaper(event.getPlayer()), PaperApiHelper.worldPosFromLocation(event.getBlock().getLocation()), ItemTypePaper.of(event.getBlock().getType()));
        if (result.cancel()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handlePlayerPlaceBlockEvent(BlockPlaceEvent event) {
        EventResult<?> result = this.dispatcher.sendPlayerPlacesBlock(new PlayerHandlePaper(event.getPlayer()), PaperApiHelper.worldPosFromLocation(event.getBlock().getLocation()), ItemTypePaper.of(event.getBlock().getType()));
        if (result.cancel()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handlePlayerStatisticIncrementEvent(PlayerStatisticIncrementEvent event) {
        EventResult<?> result = this.dispatcher.sendPlayerStatisticIncrement(new PlayerHandlePaper(event.getPlayer()), StatisticHandlePaper.create(event.getStatistic(), event.getEntityType(), event.getMaterial()), event.getNewValue());
        if (result.cancel()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void handlePlayerAdvancementEvent(PlayerAdvancementDoneEvent event) {
        this.dispatcher.sendPlayerAdvancementDone(new PlayerHandlePaper(event.getPlayer()), new AdvancementHandlePaper(event.getAdvancement()));
    }

    @EventHandler
    public void handlePlayerPickupItemEvent(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        EventResult<EventResults.PlayerPickupResult> result = this.dispatcher.sendPlayerPickupStack(new PlayerHandlePaper(player), new StackHandlePaper(event.getItem().getItemStack()), PaperApiHelper.worldPosFromLocation(event.getItem().getLocation()));
        if (result.cancel()) {
            event.setCancelled(true);
        }
        if (result.data() == null) {
            return;
        }
        if (result.data().removeItem()) {
            event.getItem().getItemStack().setAmount(0);
            return;
        }
        if (result.data().overwriteItem() && result.data().newItem() != null) {
            event.getItem().setItemStack(((StackHandlePaper)result.data().newItem()).handle());
        }
    }

    @EventHandler
    public void handlePlayerInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        EventResult<?> result = this.dispatcher.sendPlayerInventoryClick(new PlayerHandlePaper(player), new StackHandlePaper(event.getWhoClicked().getItemOnCursor()), event.getSlotType() == InventoryType.SlotType.RESULT, event.isShiftClick());
        if (result.cancel()) {
            event.setCancelled(true);
        }
    }
}

