/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.inventory;

import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.inventory.InventoryMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.action.MenuAction;
import io.github.steaf23.bingoreloaded.lib.inventory.action.MenuItemGroup;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMenu
implements InventoryMenu {
    public static Component pluginTitlePrefix = Component.empty();
    public static ItemTemplate BLANK = new ItemTemplate(ItemTypePaper.of(Material.BLACK_STAINED_GLASS_PANE), null, new Component[0]).setNoTooltip(true);
    private final Inventory inventory;
    private final MenuBoard manager;
    private int maxStackSizeOverride = -1;
    private final MenuItemGroup itemGroup;
    private Component title;
    private boolean openOnce;

    public BasicMenu(MenuBoard manager, Component initialTitle, int rows) {
        this(manager, Bukkit.createInventory(null, (int)(rows * 9), (Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(pluginTitlePrefix)).append(initialTitle)).build()));
        this.title = initialTitle;
    }

    public BasicMenu(MenuBoard manager, Component initialTitle, boolean usePrefix) {
        this(manager, Bukkit.createInventory(null, (int)54, (Component)(usePrefix ? ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(pluginTitlePrefix)).append(initialTitle)).build() : initialTitle)));
        this.title = Component.empty();
    }

    public BasicMenu(MenuBoard manager, Component initialTitle, InventoryType type) {
        this(manager, Bukkit.createInventory(null, (InventoryType)type, (Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(pluginTitlePrefix)).append(initialTitle)).build()));
        this.title = initialTitle;
    }

    private BasicMenu(MenuBoard manager, Inventory inventory) {
        this.inventory = inventory;
        this.manager = manager;
        this.itemGroup = new MenuItemGroup();
    }

    public void open(PlayerHandle player) {
        this.manager.open(this, player);
    }

    public void open(PlayerHandle player, boolean openOnce) {
        this.setOpenOnce(openOnce);
        this.manager.open(this, player);
    }

    public void close(PlayerHandle player) {
        this.manager.close(this, player);
    }

    public void reopen(PlayerHandle player) {
        Bukkit.getScheduler().runTask((Plugin)this.getMenuBoard().plugin(), t -> this.beforeOpening(player));
    }

    @Nullable
    public ItemTemplate getItemAtSlot(int slot) {
        for (ItemTemplate item : this.itemGroup.items) {
            if (item.getSlot() != slot) continue;
            return item;
        }
        return null;
    }

    public BasicMenu addItem(@NotNull ItemTemplate item, @Nullable MenuAction action, boolean replaceExisting) {
        if (this.maxStackSizeOverride != -1) {
            this.getInventory().setMaxStackSize(this.maxStackSizeOverride);
        }
        if (!replaceExisting && this.getInventory().getItem(item.getSlot()) != null) {
            return this;
        }
        this.itemGroup.addItem(item, action);
        this.getInventory().setItem(item.getSlot(), ((StackHandlePaper)item.buildItem()).handle());
        return this;
    }

    public BasicMenu addItem(@NotNull ItemTemplate item) {
        return this.addItem(item, null, true);
    }

    public BasicMenu addItem(@NotNull ItemTemplate item, @Nullable MenuAction action) {
        return this.addItem(item, action, true);
    }

    public BasicMenu addAction(MenuAction action) {
        if (action.item() == null) {
            ConsoleMessenger.bug("Cannot add action as it does not contain any item!", (Object)this);
            return this;
        }
        this.addItem(action.item(), action);
        return this;
    }

    public MenuAction addAction(@NotNull ItemTemplate item, final Consumer<MenuAction.ActionArguments> action) {
        MenuAction menuAction = new MenuAction(this){

            @Override
            public void use(MenuAction.ActionArguments arguments) {
                action.accept(arguments);
            }
        };
        this.addItem(item, menuAction);
        return menuAction;
    }

    public BasicMenu addCloseAction(@NotNull ItemTemplate item) {
        MenuAction closeAction = new MenuAction(){

            @Override
            public void use(MenuAction.ActionArguments arguments) {
                BasicMenu.this.close(arguments.player());
            }
        };
        this.addItem(item, closeAction);
        return this;
    }

    public void addItems(ItemTemplate ... items) {
        for (ItemTemplate item : items) {
            this.addItem(item, null);
        }
    }

    public void addActions(MenuAction ... actions) {
        for (MenuAction action : actions) {
            this.addAction(action);
        }
    }

    public BasicMenu removeItem(int slotIdx) {
        this.getInventory().setItem(slotIdx, null);
        this.itemGroup.removeItem(slotIdx);
        return this;
    }

    protected void setMaxStackSizeOverride(int maxValue) {
        this.maxStackSizeOverride = Math.min(64, Math.max(1, maxValue));
    }

    @Override
    public MenuBoard getMenuBoard() {
        return this.manager;
    }

    @Override
    public void beforeOpening(PlayerHandle player) {
    }

    @Override
    public boolean onClick(InventoryClickEvent event, PlayerHandle player, int clickedSlot, ClickType clickType) {
        return this.itemGroup.handleClick(this, event, player, clickedSlot, clickType);
    }

    @Override
    public boolean onDrag(InventoryDragEvent event) {
        return true;
    }

    @Override
    public void onCustomAction(Key key, DataStorage payload) {
    }

    @Override
    public void beforeClosing(PlayerHandle player) {
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public String toString() {
        return "BasicMenu{" + String.valueOf(this.title) + "}";
    }

    @Override
    public void setOpenOnce(boolean value) {
        this.openOnce = value;
    }

    @Override
    public boolean openOnce() {
        return this.openOnce;
    }
}

