/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.inventory;

import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;

public final class ColorPickerMenu
extends BasicMenu {
    private static final ItemTemplate NEXT = new ItemTemplate(53, ItemTypePaper.of(Material.STRUCTURE_VOID), ((TextComponent)Component.text("Scroll Left").color(NamedTextColor.LIGHT_PURPLE)).decorate(TextDecoration.BOLD), new Component[0]);
    private static final ItemTemplate PREVIOUS = new ItemTemplate(45, ItemTypePaper.of(Material.BARRIER), ((TextComponent)Component.text("Scroll Right").color(NamedTextColor.LIGHT_PURPLE)).decorate(TextDecoration.BOLD), new Component[0]);
    private static final int HUE_AMOUNT = 25;
    private final Consumer<TextColor> result;
    private final List<ItemTemplate> hueItems;
    private int scrollIndex = 0;

    public ColorPickerMenu(MenuBoard manager, Component title, Consumer<TextColor> result) {
        super(manager, title, 6);
        int i;
        this.result = result;
        this.hueItems = new ArrayList<ItemTemplate>();
        for (i = 0; i < 25; ++i) {
            Color col = Color.getHSBColor((float)i * 0.041666668f, 1.0f, 1.0f);
            TextColor textColor = TextColor.color(col.getRGB());
            this.hueItems.add(ItemTemplate.createColoredLeather(textColor, ItemTypePaper.of(Material.LEATHER_CHESTPLATE)).setCompareKey(textColor.asHexString()));
        }
        this.addItem(PREVIOUS);
        this.addItem(NEXT);
        this.setHueBar(0);
        for (i = 0; i < 45; ++i) {
            TextColor color = TextColor.color(0);
            this.addItem(ItemTemplate.createColoredLeather(color, ItemTypePaper.of(Material.LEATHER_CHESTPLATE)).setCompareKey(color.asHexString()));
        }
        this.updateDisplay(new Color(Integer.parseInt(this.hueItems.getFirst().getCompareKey().substring(1), 16)));
    }

    @Override
    public boolean onClick(InventoryClickEvent event, PlayerHandle player, int clickedSlot, ClickType clickType) {
        ItemTemplate item = this.getItemAtSlot(clickedSlot);
        if (item == null) {
            return super.onClick(event, player, clickedSlot, clickType);
        }
        if (clickedSlot == 53) {
            this.scrollIndex -= 3;
            this.setHueBar(this.scrollIndex);
        } else if (clickedSlot == 45) {
            this.scrollIndex += 3;
            this.setHueBar(this.scrollIndex);
        } else if (clickedSlot > 45 && clickedSlot < 53) {
            String hex = item.getCompareKey();
            this.updateDisplay(new Color(Integer.parseInt(hex.substring(1), 16)));
        } else {
            String key = item.getCompareKey();
            this.close(player);
            this.result.accept(TextColor.fromHexString(key));
        }
        return super.onClick(event, player, clickedSlot, clickType);
    }

    private void setHueBar(int startingFrom) {
        if (this.hueItems.size() < 7) {
            ConsoleMessenger.error("Add at least 7 hue items!");
            return;
        }
        for (int i = 0; i < 7; ++i) {
            this.addItem(this.hueItems.get(Math.floorMod(i + startingFrom, this.hueItems.size())).copyToSlot(1 + i, 5));
        }
    }

    private void updateDisplay(Color color) {
        float hue = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[0];
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 9; ++x) {
                float saturation = 1.0f - (float)y * 0.25f;
                float brightness = 1.0f - (float)x * 0.125f;
                Color targetColor = Color.getHSBColor(hue, saturation, brightness);
                TextColor textColor = TextColor.color(targetColor.getRGB());
                ItemTemplate item = ItemTemplate.createColoredLeather(textColor, ItemTypePaper.of(Material.LEATHER_CHESTPLATE)).setCompareKey(textColor.asHexString()).setSlot(x, y);
                this.addItem(item);
            }
        }
    }
}

