/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.inventory;

import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandlePaper;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataStorage;
import io.github.steaf23.bingoreloaded.lib.events.PlayerDisplayAnvilTextChangedEvent;
import io.github.steaf23.bingoreloaded.lib.events.PlayerDisplayCustomClickActionEvent;
import io.github.steaf23.bingoreloaded.lib.inventory.InventoryMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.Menu;
import io.github.steaf23.bingoreloaded.lib.inventory.MenuPacketListener;
import io.github.steaf23.bingoreloaded.lib.inventory.UserInputMenu;
import io.github.steaf23.bingoreloaded.lib.util.NBTConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MenuBoardPaper
implements MenuBoard,
Listener {
    protected final Map<UUID, Stack<Menu>> activeMenus;
    private final MenuPacketListener packetListener;
    private final JavaPlugin plugin;
    private static final Set<ClickType> CLICK_TYPES_TO_IGNORE = Set.of(ClickType.DOUBLE_CLICK, ClickType.DROP, ClickType.CREATIVE, ClickType.CONTROL_DROP, ClickType.SWAP_OFFHAND);

    public MenuBoardPaper(ServerSoftware server, JavaPlugin plugin) {
        this.plugin = plugin;
        this.activeMenus = new HashMap<UUID, Stack<Menu>>();
        this.packetListener = new MenuPacketListener(server);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void close(Menu menu, PlayerHandle player) {
        UUID playerId = player.uniqueId();
        if (!this.activeMenus.containsKey(playerId)) {
            return;
        }
        Stack<Menu> menus = this.activeMenus.get(playerId);
        if (menus.peek() != menu) {
            return;
        }
        Menu menuToClose = menus.pop();
        menuToClose.beforeClosing(player);
        if (menus.isEmpty()) {
            this.activeMenus.remove(playerId);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, task -> player.closeInventory());
        } else {
            this.open(this.activeMenus.get(playerId).peek(), player);
        }
    }

    @Override
    public void closeAll(PlayerHandle player) {
        UUID playerId = player.uniqueId();
        if (!this.activeMenus.containsKey(playerId)) {
            return;
        }
        Stack<Menu> menus = this.activeMenus.get(playerId);
        while (!this.activeMenus.get(playerId).isEmpty()) {
            menus.pop().beforeClosing(player);
        }
        this.activeMenus.remove(playerId);
        player.closeInventory();
    }

    @Override
    public JavaPlugin plugin() {
        return this.plugin;
    }

    @Override
    public void open(Menu menu, PlayerHandle player) {
        Stack<Menu> menuStack;
        UUID playerId = player.uniqueId();
        if (!this.activeMenus.containsKey(playerId)) {
            this.activeMenus.put(playerId, new Stack());
        }
        if (!(menuStack = this.activeMenus.get(playerId)).isEmpty() && menuStack.peek().openOnce()) {
            menuStack.pop().beforeClosing(player);
        }
        if (!menuStack.contains(menu)) {
            menuStack.push(menu);
        }
        if (menuStack.peek() != menu) {
            return;
        }
        menu.beforeOpening(player);
        if (menu instanceof InventoryMenu) {
            InventoryMenu invMenu = (InventoryMenu)menu;
            invMenu.openInventory(player);
        }
    }

    @EventHandler
    public void handleInventoryClick(InventoryClickEvent event) {
        InventoryMenu invMenu;
        UUID playerId = event.getWhoClicked().getUniqueId();
        if (!this.activeMenus.containsKey(playerId)) {
            return;
        }
        Menu menu = this.activeMenus.get(playerId).peek();
        if (!(menu instanceof InventoryMenu) || (invMenu = (InventoryMenu)menu).getInventory() != event.getInventory()) {
            return;
        }
        event.setCancelled(true);
        if (CLICK_TYPES_TO_IGNORE.contains(event.getClick())) {
            return;
        }
        if (event.getInventory().getSize() < event.getRawSlot() || event.getRawSlot() < 0 || event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        boolean cancel = menu.onClick(event, new PlayerHandlePaper((Player)event.getWhoClicked()), event.getRawSlot(), event.getClick());
        event.setCancelled(cancel);
    }

    @EventHandler
    public void handleInventoryDrag(InventoryDragEvent event) {
        InventoryMenu invMenu;
        UUID playerId = event.getWhoClicked().getUniqueId();
        if (!this.activeMenus.containsKey(playerId)) {
            return;
        }
        Menu menu = this.activeMenus.get(playerId).peek();
        if (!(menu instanceof InventoryMenu) || (invMenu = (InventoryMenu)menu).getInventory() != event.getInventory()) {
            return;
        }
        boolean cancel = menu.onDrag(event);
        event.setCancelled(cancel);
    }

    @EventHandler
    public void handleInventoryClose(InventoryCloseEvent event) {
        InventoryMenu invMenu;
        UUID playerId = event.getPlayer().getUniqueId();
        if (!this.activeMenus.containsKey(playerId)) {
            return;
        }
        Menu topMenu = this.activeMenus.get(playerId).peek();
        if (topMenu instanceof InventoryMenu && (invMenu = (InventoryMenu)topMenu).getInventory() == event.getInventory()) {
            this.close(topMenu, new PlayerHandlePaper((Player)event.getPlayer()));
        }
    }

    @EventHandler
    public void handlePlayerQuit(PlayerQuitEvent event) {
        if (this.activeMenus.containsKey(event.getPlayer().getUniqueId())) {
            this.closeAll(new PlayerHandlePaper(event.getPlayer()));
        }
    }

    @EventHandler
    public void handlePlayerDisplayAnvilTextChanged(PlayerDisplayAnvilTextChangedEvent event) {
        UUID playerId = event.getUserId();
        if (!this.activeMenus.containsKey(playerId)) {
            return;
        }
        Menu topMenu = this.activeMenus.get(playerId).peek();
        if (topMenu instanceof UserInputMenu) {
            UserInputMenu inputMenu = (UserInputMenu)topMenu;
            inputMenu.handleTextChanged(event.getNewText());
        }
    }

    @EventHandler
    public void handlePlayerDisplayCustomClickAction(PlayerDisplayCustomClickActionEvent event) {
        UUID playerId = event.getUserId();
        if (!this.activeMenus.containsKey(playerId)) {
            return;
        }
        Menu topMenu = this.activeMenus.get(playerId).peek();
        TagDataStorage payload = new TagDataStorage(NBTConverter.tagFromPacketEventsNBT(event.getPayload()));
        topMenu.onCustomAction(event.getActionKey(), payload);
    }
}

