/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.inventory;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.SimplePacketListenerAbstract;
import com.github.retrooper.packetevents.event.simple.PacketPlayReceiveEvent;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientCustomClickAction;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientNameItem;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.events.PlayerDisplayAnvilTextChangedEvent;
import io.github.steaf23.bingoreloaded.lib.events.PlayerDisplayCustomClickActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class MenuPacketListener
extends SimplePacketListenerAbstract {
    protected final Map<UUID, Integer> openPlayerInventories;
    private final ServerSoftware server;

    public MenuPacketListener(ServerSoftware server) {
        this.server = server;
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this);
        this.openPlayerInventories = new HashMap<UUID, Integer>();
    }

    public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.NAME_ITEM) {
            WrapperPlayClientNameItem nameItem = new WrapperPlayClientNameItem((PacketReceiveEvent)event);
            this.server.runTask(t -> {
                PlayerDisplayAnvilTextChangedEvent textChangedEvent = new PlayerDisplayAnvilTextChangedEvent(nameItem.getItemName(), event.getUser().getUUID());
                Bukkit.getPluginManager().callEvent((Event)textChangedEvent);
            });
        } else if (event.getPacketType() == PacketType.Play.Client.CUSTOM_CLICK_ACTION) {
            WrapperPlayClientCustomClickAction customClickAction = new WrapperPlayClientCustomClickAction((PacketReceiveEvent)event);
            this.server.runTask(t -> {
                PlayerDisplayCustomClickActionEvent customClickActionEvent = new PlayerDisplayCustomClickActionEvent(event.getUser().getUUID(), customClickAction.getId().key(), (NBTCompound)customClickAction.getPayload());
                Bukkit.getPluginManager().callEvent((Event)customClickActionEvent);
            });
        }
    }
}

