/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.inventory;

import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.FilterType;
import io.github.steaf23.bingoreloaded.lib.inventory.MenuFilterSettings;
import io.github.steaf23.bingoreloaded.lib.inventory.PaginatedSelectionMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.UserInputMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.action.MenuAction;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.util.PlayerDisplayTranslationKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;

public abstract class PaginatedDataMenu<Data>
extends BasicMenu {
    public static final int ITEMS_PER_PAGE = 45;
    private final List<Data> allItems;
    private final Set<Data> selectedItems;
    private Function<Data, Boolean> customFilter;
    private final List<Data> filteredItems;
    private int pageAmount;
    private int currentPage;
    private String keywordFilter;
    private MenuFilterSettings appliedFilter;
    private final MenuAction filterAction;
    private final MenuAction nextPageAction = this.addAction(NEXT.copy(), args -> this.nextPage());
    private final MenuAction previousPageAction;
    protected static final ItemTemplate NEXT = new ItemTemplate(8, 5, ItemTypePaper.of(Material.STRUCTURE_VOID), PlayerDisplayTranslationKey.MENU_NEXT.translate().color(NamedTextColor.LIGHT_PURPLE).decorate(TextDecoration.BOLD), new Component[0]);
    protected static final ItemTemplate PREVIOUS = new ItemTemplate(0, 5, ItemTypePaper.of(Material.BARRIER), PlayerDisplayTranslationKey.MENU_PREVIOUS.translate().color(NamedTextColor.LIGHT_PURPLE).decorate(TextDecoration.BOLD), new Component[0]);
    protected static final ItemTemplate CLOSE = new ItemTemplate(4, 5, ItemTypePaper.of(Material.REDSTONE), PlayerDisplayTranslationKey.MENU_SAVE_EXIT.translate().color(NamedTextColor.RED).decorate(TextDecoration.BOLD), new Component[0]);
    protected static final ItemTemplate FILTER = new ItemTemplate(1, 5, ItemTypePaper.of(Material.HOPPER), PlayerDisplayTranslationKey.MENU_FILTER.translate().color(NamedTextColor.GOLD).decorate(TextDecoration.BOLD), new Component[0]);

    public abstract void onOptionClickedDelegate(InventoryClickEvent var1, Data var2, PlayerHandle var3);

    public abstract ItemTemplate toItem(Data var1, boolean var2);

    public abstract boolean filterData(Data var1, MenuFilterSettings var2);

    public PaginatedDataMenu(MenuBoard board, Component initialTitle, List<Data> options, Function<Data, Boolean> customFilter) {
        this(board, initialTitle, options, List.of(FilterType.CUSTOM));
        this.customFilter = customFilter;
    }

    public PaginatedDataMenu(MenuBoard board, Component initialTitle, List<Data> options, FilterType filterType) {
        this(board, initialTitle, options, List.of(filterType));
    }

    public PaginatedDataMenu(MenuBoard board, Component initialTitle, List<Data> options, List<FilterType> availableFilterTypes) {
        super(board, initialTitle, 6);
        if (availableFilterTypes.isEmpty() || availableFilterTypes.size() == 1 && availableFilterTypes.getFirst() == FilterType.NONE) {
            this.addItem(BLANK.copyToSlot(1, 5));
            this.filterAction = null;
        } else {
            this.filterAction = this.addAction(FILTER.copy(), args -> new UserInputMenu(this.getMenuBoard(), Component.text("Filter on..."), f -> this.applyFilter(new MenuFilterSettings((FilterType)((Object)((Object)((Object)availableFilterTypes.getFirst()))), (String)f)), this.appliedFilter.name()).open(args.player()));
        }
        this.previousPageAction = this.addAction(PREVIOUS.copy(), args -> this.previousPage());
        this.addItems(BLANK.copyToSlot(2, 5), BLANK.copyToSlot(3, 5), BLANK.copyToSlot(5, 5), BLANK.copyToSlot(6, 5), BLANK.copyToSlot(7, 5));
        this.addCloseAction(CLOSE.copy());
        this.currentPage = 0;
        this.allItems = options;
        this.selectedItems = new HashSet<Data>();
        this.filteredItems = new ArrayList<Data>(options);
        this.appliedFilter = MenuFilterSettings.EMPTY;
        this.clearFilter();
    }

    @Override
    public boolean onClick(InventoryClickEvent event, PlayerHandle player, int clickedSlot, ClickType clickType) {
        boolean isValidSlot;
        boolean cancel = super.onClick(event, player, clickedSlot, clickType);
        boolean bl = isValidSlot = 45 * this.currentPage + event.getRawSlot() < this.filteredItems.size() && event.getRawSlot() < 45;
        if (isValidSlot) {
            Data item = this.filteredItems.get(45 * this.currentPage + event.getRawSlot());
            this.onOptionClickedDelegate(event, item, player);
        }
        return cancel;
    }

    @Override
    public void onCustomAction(Key key, DataStorage payload) {
        ConsoleMessenger.log("Received " + key.asMinimalString() + " and " + payload.getString("filter", ""));
        String filterTypeStr = payload.getString("filter_option", "NONE");
        try {
            this.applyFilter(new MenuFilterSettings(FilterType.valueOf(filterTypeStr), payload.getString("filter", "")));
        }
        catch (IllegalArgumentException illegalFilterTypeException) {
            ConsoleMessenger.bug("Unknown filter type '" + filterTypeStr + "' from filter dialog", PaginatedSelectionMenu.class);
        }
    }

    public void applyFilter(MenuFilterSettings filter) {
        if (filter.filterType() == FilterType.NONE || this.filterAction == null) {
            return;
        }
        this.appliedFilter = filter;
        this.filterAction.item().setLore(Component.text("{" + this.appliedFilter.name() + "}"));
        this.addAction(this.filterAction);
        this.filteredItems.clear();
        for (Data data : this.allItems) {
            if (!this.filterData(data, this.appliedFilter)) continue;
            this.filteredItems.add(data);
        }
        this.currentPage = 0;
        this.updatePageAmount();
        this.updatePage();
    }

    public MenuFilterSettings getAppliedFilter() {
        return this.appliedFilter;
    }

    public void addItemsToSelect(Collection<Data> newItems) {
        this.allItems.addAll(newItems);
        this.clearFilter();
    }

    public void removeItems(int ... itemIndices) {
        for (int i : itemIndices) {
            this.allItems.remove(i);
        }
        this.updatePage();
    }

    public void clearItems() {
        this.allItems.clear();
        this.updatePage();
    }

    public List<Data> getAllItems() {
        return this.allItems;
    }

    public Set<Data> getSelectedItems() {
        return this.selectedItems;
    }

    public void selectItem(Data item, boolean value) {
        if (!this.allItems.contains(item)) {
            return;
        }
        if (value) {
            this.selectedItems.add(item);
        } else {
            this.selectedItems.remove(item);
        }
        this.updatePage();
    }

    protected void nextPage() {
        this.updatePageAmount();
        this.currentPage = Math.floorMod(this.currentPage + 1, this.pageAmount);
        this.updatePage();
    }

    protected void previousPage() {
        this.updatePageAmount();
        this.currentPage = Math.floorMod(this.currentPage - 1, this.pageAmount);
        this.updatePage();
    }

    protected void updatePage() {
        this.updatePageAmount();
        int startingIndex = this.currentPage * 45;
        for (int i = 0; i < 45; ++i) {
            if (startingIndex + i < this.filteredItems.size()) {
                Data d = this.filteredItems.get(startingIndex + i);
                boolean selected = this.selectedItems.contains(d);
                ItemTemplate template = this.toItem(d, selected);
                template.setGlowing(this.selectedItems.contains(d));
                this.addItem(template.copyToSlot(i));
                continue;
            }
            this.addItem(ItemTemplate.EMPTY.copyToSlot(i));
        }
        TextComponent pageCountDesc = Component.text(String.format("%02d", this.currentPage + 1) + "/" + String.format("%02d", this.pageAmount));
        this.nextPageAction.item().setLore(pageCountDesc);
        this.previousPageAction.item().setLore(pageCountDesc);
        this.addActions(this.nextPageAction, this.previousPageAction);
    }

    private void updatePageAmount() {
        this.pageAmount = Math.max(1, (int)Math.ceil((double)this.filteredItems.size() / 45.0));
    }

    public void clearFilter() {
        if (this.appliedFilter.filterType() == FilterType.NONE) {
            this.filteredItems.clear();
            this.filteredItems.addAll(this.allItems);
            this.updatePage();
        }
        this.applyFilter(new MenuFilterSettings(FilterType.NONE, ""));
    }
}

