/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.inventory;

import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.DataStorage;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.FilterType;
import io.github.steaf23.bingoreloaded.lib.inventory.MenuFilterSettings;
import io.github.steaf23.bingoreloaded.lib.inventory.UserInputMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.util.PlayerDisplayTranslationKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;

public abstract class PaginatedSelectionMenu
extends BasicMenu {
    public static final int ITEMS_PER_PAGE = 45;
    private final List<ItemTemplate> allItems;
    private final List<ItemTemplate> selectedItems;
    private Function<ItemTemplate, Boolean> customFilter;
    private final List<ItemTemplate> filteredItems;
    private int pageAmount;
    private int currentPage;
    private String keywordFilter;
    private MenuFilterSettings appliedFilter;
    private final ItemTemplate filterItem = FILTER.copy();
    private final ItemTemplate nextPageItem = NEXT.copy();
    private final ItemTemplate previousPageItem = PREVIOUS.copy();
    protected static final ItemTemplate NEXT = new ItemTemplate(8, 5, ItemTypePaper.of(Material.STRUCTURE_VOID), PlayerDisplayTranslationKey.MENU_NEXT.translate().color(NamedTextColor.LIGHT_PURPLE).decorate(TextDecoration.BOLD), new Component[0]);
    protected static final ItemTemplate PREVIOUS = new ItemTemplate(0, 5, ItemTypePaper.of(Material.BARRIER), PlayerDisplayTranslationKey.MENU_PREVIOUS.translate().color(NamedTextColor.LIGHT_PURPLE).decorate(TextDecoration.BOLD), new Component[0]);
    protected static final ItemTemplate CLOSE = new ItemTemplate(4, 5, ItemTypePaper.of(Material.REDSTONE), PlayerDisplayTranslationKey.MENU_SAVE_EXIT.translate().color(NamedTextColor.RED).decorate(TextDecoration.BOLD), new Component[0]);
    protected static final ItemTemplate FILTER = new ItemTemplate(1, 5, ItemTypePaper.of(Material.HOPPER), PlayerDisplayTranslationKey.MENU_FILTER.translate().color(NamedTextColor.GOLD).decorate(TextDecoration.BOLD), new Component[0]);

    public abstract void onOptionClickedDelegate(InventoryClickEvent var1, ItemTemplate var2, PlayerHandle var3);

    public PaginatedSelectionMenu(MenuBoard board, Component initialTitle, List<ItemTemplate> options, Function<ItemTemplate, Boolean> customFilter) {
        this(board, initialTitle, options, List.of(FilterType.CUSTOM));
        this.customFilter = customFilter;
    }

    public PaginatedSelectionMenu(MenuBoard board, Component initialTitle, List<ItemTemplate> options, FilterType filterType) {
        this(board, initialTitle, options, List.of(filterType));
    }

    public PaginatedSelectionMenu(MenuBoard board, Component initialTitle, List<ItemTemplate> options, List<FilterType> availableFilterTypes) {
        super(board, initialTitle, 6);
        this.addAction(this.nextPageItem, args -> this.nextPage());
        if (availableFilterTypes.isEmpty() || availableFilterTypes.size() == 1 && availableFilterTypes.getFirst() == FilterType.NONE) {
            this.addItem(BLANK.copyToSlot(1, 5));
        } else {
            this.addAction(this.filterItem, args -> new UserInputMenu(this.getMenuBoard(), Component.text("Filter on..."), f -> this.applyFilter(new MenuFilterSettings((FilterType)((Object)((Object)((Object)availableFilterTypes.getFirst()))), (String)f)), this.appliedFilter.name()).open(args.player()));
        }
        this.addAction(this.previousPageItem, args -> this.previousPage());
        this.addItems(BLANK.copyToSlot(2, 5), BLANK.copyToSlot(3, 5), BLANK.copyToSlot(5, 5), BLANK.copyToSlot(6, 5), BLANK.copyToSlot(7, 5));
        this.addCloseAction(CLOSE.copy());
        this.currentPage = 0;
        this.allItems = options;
        this.selectedItems = new ArrayList<ItemTemplate>();
        this.filteredItems = new ArrayList<ItemTemplate>(options);
        this.appliedFilter = MenuFilterSettings.EMPTY;
        this.clearFilter();
    }

    @Override
    public boolean onClick(InventoryClickEvent event, PlayerHandle player, int clickedSlot, ClickType clickType) {
        boolean isValidSlot;
        boolean cancel = super.onClick(event, player, clickedSlot, clickType);
        boolean bl = isValidSlot = 45 * this.currentPage + event.getRawSlot() < this.filteredItems.size() && event.getRawSlot() < 45;
        if (isValidSlot) {
            ItemTemplate item = this.filteredItems.get(45 * this.currentPage + event.getRawSlot());
            this.onOptionClickedDelegate(event, item.setSlot(clickedSlot), player);
        }
        return cancel;
    }

    @Override
    public void onCustomAction(Key key, DataStorage payload) {
        ConsoleMessenger.log("Received " + key.asMinimalString() + " and " + payload.getString("filter", ""));
        String filterTypeStr = payload.getString("filter_option", "NONE");
        try {
            this.applyFilter(new MenuFilterSettings(FilterType.valueOf(filterTypeStr), payload.getString("filter", "")));
        }
        catch (IllegalArgumentException illegalFilterTypeException) {
            ConsoleMessenger.bug("Unknown filter type '" + filterTypeStr + "' from filter dialog", PaginatedSelectionMenu.class);
        }
    }

    public void applyFilter(MenuFilterSettings filter) {
        if (filter.filterType() == FilterType.NONE) {
            return;
        }
        this.appliedFilter = filter;
        this.filterItem.setLore(Component.text("{" + this.appliedFilter.name() + "}"));
        this.addItem(this.filterItem);
        this.filteredItems.clear();
        Function<ItemTemplate, Boolean> filterCriteria = switch (filter.filterType()) {
            case FilterType.ITEM_ID -> item -> item.getCompareKey().contains(this.appliedFilter.name());
            case FilterType.MATERIAL -> item -> {
                String name = item.getItemType().key().value().replace("_", " ");
                return name.toLowerCase().contains(this.appliedFilter.name().toLowerCase());
            };
            case FilterType.DISPLAY_NAME -> item -> item.getPlainTextName().toLowerCase().contains(this.appliedFilter.name().toLowerCase());
            case FilterType.CUSTOM -> this.customFilter;
            default -> throw new IllegalStateException("Unexpected filter type while filtering menu items: " + String.valueOf((Object)filter.filterType()));
        };
        for (ItemTemplate item2 : this.allItems) {
            if (!filterCriteria.apply(item2).booleanValue()) continue;
            this.filteredItems.add(item2);
        }
        this.currentPage = 0;
        this.updatePageAmount();
        this.updatePage();
    }

    public MenuFilterSettings getAppliedFilter() {
        return this.appliedFilter;
    }

    public void addItemsToSelect(Collection<ItemTemplate> newItems) {
        ItemTemplate lastItem;
        while (!this.allItems.isEmpty() && (lastItem = this.allItems.getLast()).isEmpty()) {
            this.allItems.remove(lastItem);
        }
        this.allItems.addAll(newItems);
        this.clearFilter();
    }

    public void removeItems(int ... itemIndices) {
        ItemTemplate lastItem;
        while (!this.allItems.isEmpty() && (lastItem = this.allItems.getLast()).isEmpty()) {
            this.allItems.remove(lastItem);
        }
        for (int i : itemIndices) {
            this.allItems.remove(i);
        }
        this.updatePage();
    }

    public void clearItems() {
        this.allItems.clear();
        this.updatePage();
    }

    public List<ItemTemplate> getAllItems() {
        return this.allItems;
    }

    public List<ItemTemplate> getSelectedItems() {
        return this.selectedItems;
    }

    public void selectItem(ItemTemplate item, boolean value) {
        if (!this.allItems.contains(item)) {
            return;
        }
        if (value) {
            this.selectedItems.add(item);
        } else {
            this.selectedItems.remove(item);
        }
        item.setGlowing(value);
        this.allItems.set(this.allItems.indexOf(item), item);
        this.updatePage();
    }

    protected void nextPage() {
        this.updatePageAmount();
        this.currentPage = Math.floorMod(this.currentPage + 1, this.pageAmount);
        this.updatePage();
    }

    protected void previousPage() {
        this.updatePageAmount();
        this.currentPage = Math.floorMod(this.currentPage - 1, this.pageAmount);
        this.updatePage();
    }

    protected void updatePage() {
        this.updatePageAmount();
        int startingIndex = this.currentPage * 45;
        for (int i = 0; i < 45; ++i) {
            if (startingIndex + i < this.filteredItems.size()) {
                this.addItem(this.filteredItems.get(startingIndex + i).copyToSlot(i));
                continue;
            }
            this.addItem(ItemTemplate.EMPTY.copyToSlot(i));
        }
        TextComponent pageCountDesc = Component.text(String.format("%02d", this.currentPage + 1) + "/" + String.format("%02d", this.pageAmount));
        this.nextPageItem.setLore(pageCountDesc);
        this.previousPageItem.setLore(pageCountDesc);
        this.addItems(this.nextPageItem, this.previousPageItem);
    }

    private void updatePageAmount() {
        this.pageAmount = Math.max(1, (int)Math.ceil((double)this.filteredItems.size() / 45.0));
    }

    public void replaceItem(ItemTemplate newItem, int slot) {
        ItemTemplate oldItem = this.filteredItems.get(45 * this.currentPage + slot);
        this.replaceItem(newItem, oldItem);
    }

    public void replaceItem(ItemTemplate newItem, ItemTemplate oldItem) {
        if (!this.allItems.contains(oldItem)) {
            return;
        }
        this.allItems.set(this.allItems.indexOf(oldItem), newItem);
        if (this.filteredItems.contains(oldItem)) {
            this.filteredItems.set(this.filteredItems.indexOf(oldItem), newItem);
        }
        this.selectedItems.remove(oldItem);
    }

    public void clearFilter() {
        if (this.appliedFilter.filterType() == FilterType.NONE) {
            this.filteredItems.clear();
            this.filteredItems.addAll(this.allItems);
            this.updatePage();
        }
        this.applyFilter(new MenuFilterSettings(FilterType.NONE, ""));
    }
}

