/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.inventory;

import io.github.steaf23.bingoreloaded.lib.api.MenuBoard;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemTypePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import io.github.steaf23.bingoreloaded.lib.util.PlayerDisplayTranslationKey;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;

public class UserInputMenu
extends BasicMenu {
    private final Consumer<String> resultAction;
    private String text;
    private final ItemTemplate save = new ItemTemplate(2, ItemTypePaper.of(Material.EMERALD), PlayerDisplayTranslationKey.MENU_ACCEPT.translate().color(NamedTextColor.GREEN).decorate(TextDecoration.BOLD), new Component[0]);
    private static final ItemTemplate CLEAR = new ItemTemplate(1, ItemTypePaper.of(Material.HOPPER), PlayerDisplayTranslationKey.MENU_CLEAR_FILTER.translate().color(NamedTextColor.GRAY).decorate(TextDecoration.BOLD), new Component[0]);

    public UserInputMenu(MenuBoard manager, Component initialTitle, Consumer<String> result, String startingText) {
        super(manager, initialTitle, InventoryType.ANVIL);
        this.resultAction = result;
        this.text = "";
        this.addItem(new ItemTemplate(0, ItemTypePaper.of(Material.NAME_TAG), (Component)Component.text(startingText), new Component[0]));
        this.addAction(CLEAR.copy(), args -> {
            this.text = "";
            this.close(args.player());
        });
    }

    public void handleTextChanged(String newText) {
        this.text = newText;
        this.addCloseAction(this.save.setLore(Component.text(this.text)));
    }

    @Override
    public void close(PlayerHandle player) {
        super.close(player);
        this.resultAction.accept(this.text);
    }
}

