/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.inventory.action;

import io.github.steaf23.bingoreloaded.lib.inventory.BasicMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.Menu;
import io.github.steaf23.bingoreloaded.lib.inventory.action.MenuAction;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ComboBoxButtonAction
extends MenuAction {
    private final ComboBoxCallback callback;
    private final List<String> options;
    private final List<ItemTemplate> optionItem;

    private ComboBoxButtonAction(ComboBoxCallback callback) {
        this.callback = callback;
        this.options = new ArrayList<String>();
        this.optionItem = new ArrayList<ItemTemplate>();
    }

    @Override
    public void use(MenuAction.ActionArguments arguments) {
        Menu menu = arguments.menu();
        if (!(menu instanceof BasicMenu)) {
            return;
        }
        BasicMenu basicMenu = (BasicMenu)menu;
        int newIndex = this.getSelectedOptionIndex();
        if (arguments.clickType().isLeftClick()) {
            newIndex = Math.floorMod(newIndex + 1, this.options.size());
        } else if (arguments.clickType().isRightClick()) {
            newIndex = Math.floorMod(newIndex - 1, this.options.size());
        }
        int finalNewIndex = newIndex;
        Bukkit.getScheduler().runTask((Plugin)menu.getMenuBoard().plugin(), task -> {
            ItemTemplate newItem = this.optionItem.get(finalNewIndex);
            boolean shouldUpdate = this.callback.shouldUpdateItem(this.getSelectedOptionName(), newItem.getCompareKey(), arguments);
            if (!shouldUpdate) {
                return;
            }
            this.setItem(newItem);
            basicMenu.addAction(this);
        });
    }

    public int getSelectedOptionIndex() {
        return this.options.indexOf(this.getSelectedOptionName());
    }

    public String getSelectedOptionName() {
        return this.item.getCompareKey();
    }

    public ComboBoxButtonAction addOption(String name, ItemTemplate data) {
        this.options.add(name);
        this.optionItem.add(data);
        data.setCompareKey(name);
        return this;
    }

    @FunctionalInterface
    public static interface ComboBoxCallback {
        public boolean shouldUpdateItem(String var1, String var2, MenuAction.ActionArguments var3);
    }

    public static class Builder {
        private final List<ItemOption> options = new ArrayList<ItemOption>();
        private ComboBoxCallback callback = (old, current, args) -> true;

        public Builder(@NotNull String key, @NotNull ItemTemplate item) {
            this.addOption(key, item);
        }

        public Builder setCallback(@NotNull ComboBoxCallback callback) {
            this.callback = callback;
            return this;
        }

        public Builder addOption(@NotNull String key, @NotNull ItemTemplate item) {
            this.options.add(new ItemOption(key, item));
            return this;
        }

        public ComboBoxButtonAction buildAction(int slot, String startingKey) {
            int startingIndex = 0;
            for (int i = 0; i < this.options.size(); ++i) {
                if (!this.options.get(i).key().equals(startingKey)) continue;
                startingIndex = i;
                break;
            }
            return this.buildAction(slot, startingIndex);
        }

        public ComboBoxButtonAction buildAction(int slot) {
            return this.buildAction(slot, 0);
        }

        public ComboBoxButtonAction buildAction(int slot, int startingIndex) {
            if (startingIndex < 0 || startingIndex >= this.options.size()) {
                startingIndex = 0;
            }
            ItemTemplate result = this.options.get(startingIndex).item().setCompareKey(this.options.get(startingIndex).key()).copyToSlot(slot);
            ComboBoxButtonAction action = new ComboBoxButtonAction(this.callback);
            for (ItemOption option : this.options) {
                action.addOption(option.key(), option.item().copyToSlot(slot));
            }
            action.setItem(result);
            return action;
        }

        record ItemOption(String key, ItemTemplate item) {
        }
    }
}

