/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.inventory.action;

import io.github.steaf23.bingoreloaded.lib.api.item.StackHandlePaper;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.inventory.InventoryMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.action.MenuAction;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MenuItemGroup {
    public final Map<Integer, MenuAction> actions;
    public final List<ItemTemplate> items = new ArrayList<ItemTemplate>();

    public MenuItemGroup() {
        this.actions = new HashMap<Integer, MenuAction>();
    }

    public boolean handleClick(InventoryMenu menu, InventoryClickEvent event, PlayerHandle player, int clickedSlot, ClickType clickType) {
        for (ItemTemplate item : new ArrayList<ItemTemplate>(this.items)) {
            int itemSlot = item.getSlot();
            if (itemSlot != clickedSlot) continue;
            if (this.actions.containsKey(itemSlot) && this.actions.get(itemSlot) != null) {
                this.actions.get(itemSlot).use(new MenuAction.ActionArguments(menu, player, clickType));
            }
            event.getInventory().setItem(itemSlot, ((StackHandlePaper)item.buildItem()).handle());
        }
        return true;
    }

    public void addItem(ItemTemplate item, @Nullable MenuAction action) {
        this.items.removeIf(i -> i.getSlot() == item.getSlot());
        this.items.add(item);
        if (action != null) {
            action.setItem(item);
        }
        this.actions.put(item.getSlot(), action);
    }

    public void setItemAction(int slot, @NotNull MenuAction action) {
        this.actions.put(slot, action);
    }

    public void removeItem(int slot) {
        this.items.removeIf(i -> i.getSlot() == slot);
        this.actions.remove(slot);
    }
}

