/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.inventory.action;

import io.github.steaf23.bingoreloaded.lib.inventory.InventoryMenu;
import io.github.steaf23.bingoreloaded.lib.inventory.action.MenuAction;
import io.github.steaf23.bingoreloaded.lib.item.ItemTemplate;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class SpinBoxButtonAction
extends MenuAction {
    private int value;
    private int min;
    private int max;
    private Consumer<Integer> callback;

    public SpinBoxButtonAction(int minValue, int maxValue, int initialValue, @NotNull Consumer<Integer> callback) {
        maxValue = Math.min(maxValue, 64);
        this.min = Math.clamp((long)minValue, 1, maxValue);
        this.max = Math.clamp((long)maxValue, minValue, 64);
        this.value = Math.clamp((long)initialValue, this.min, this.max);
        this.callback = callback;
    }

    public SpinBoxButtonAction(int minValue, int maxValue, int initialValue) {
        maxValue = Math.min(maxValue, 64);
        this.min = Math.clamp((long)minValue, 1, maxValue);
        this.max = Math.clamp((long)maxValue, minValue, 64);
        this.value = Math.clamp((long)initialValue, this.min, this.max);
        this.callback = null;
    }

    @Override
    public void setItem(@NotNull ItemTemplate item) {
        super.setItem(item);
        item.setAmount(this.value);
        item.addDescription("input", 10, InventoryMenu.INPUT_LEFT_CLICK.append(Component.text("increase")), InventoryMenu.INPUT_RIGHT_CLICK.append(Component.text("decrease")), InventoryMenu.INPUT_SHIFT_CLICK.append(Component.text("edit faster")));
    }

    @Override
    public void use(MenuAction.ActionArguments arguments) {
        int changeBy = 1;
        if (arguments.clickType().isShiftClick()) {
            changeBy = 10;
        }
        if (arguments.clickType().isRightClick()) {
            changeBy *= -1;
        }
        this.value = Math.clamp((long)(this.value + changeBy), this.min, this.max);
        this.updateItem();
    }

    public int getValue() {
        return this.value;
    }

    public void setCallback(@NotNull Consumer<Integer> callback) {
        this.callback = callback;
    }

    public void setMax(int max) {
        this.max = Math.clamp((long)max, this.min, 64);
        int newValue = Math.clamp((long)this.value, this.min, this.max);
        if (newValue != this.value) {
            this.value = newValue;
            this.updateItem();
        }
    }

    public void setMin(int min) {
        this.min = Math.clamp((long)min, 1, this.max);
        int newValue = Math.clamp((long)this.value, this.min, this.max);
        if (newValue != this.value) {
            this.value = newValue;
            this.updateItem();
        }
    }

    private void updateItem() {
        if (this.item != null) {
            this.item.setAmount(this.value);
        }
        if (this.callback != null) {
            this.callback.accept(this.value);
        }
    }
}

