/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.item;

import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemTemplate {
    public static final ItemTemplate EMPTY = new ItemTemplate(ItemType.AIR);
    public static final Set<ItemType> LEATHER_ARMOR = Set.of(ItemType.of("minecraft:leather_chestplate"), ItemType.of("minecraft:leather_boots"), ItemType.of("minecraft:leather_leggings"), ItemType.of("minecraft:leather_helmet"));
    private int slot = 0;
    private ItemType type;
    private Component name;
    private final Map<String, DescriptionSection> description = new HashMap<String, DescriptionSection>();
    private int amount = 1;
    private boolean glowing = false;
    private boolean noTooltip = false;
    private String compareKey = null;
    private final Map<Key, Integer> enchantments = new HashMap<Key, Integer>();
    private Integer maxDamage = null;
    private Integer maxStackSize = null;
    private int currentDamage = 0;
    private String customModelData = "";
    private ItemTemplate texturedVariant = null;
    private TextColor leatherColor = null;
    private TagDataStorage extraData;
    @Nullable
    private Key cooldownGroup;

    public ItemTemplate(ItemType type) {
        this.type = type;
    }

    public ItemTemplate(ItemType type, @Nullable Component name, Component ... lore) {
        this.type = type;
        this.name = name;
        this.setLore(lore);
    }

    public ItemTemplate(int slot, ItemType type) {
        this.slot = slot;
        this.type = type;
    }

    public ItemTemplate(int slotX, int slotY, ItemType type) {
        this(ItemTemplate.slotFromXY(slotX, slotY), type);
    }

    public ItemTemplate(int slotX, int slotY, ItemType type, Component name, Component ... lore) {
        this(ItemTemplate.slotFromXY(slotX, slotY), type, name, lore);
    }

    public ItemTemplate(int slot, ItemType type, Component name, Component ... lore) {
        this.slot = slot;
        this.type = type;
        this.name = name;
        this.setLore(lore);
    }

    @NotNull
    public String getPlainTextName() {
        return this.name == null ? "" : PlainTextComponentSerializer.plainText().serialize(this.name);
    }

    public Component getName() {
        return this.name;
    }

    public ItemTemplate setName(@Nullable Component name) {
        this.name = name;
        return this;
    }

    public ItemTemplate setLore(Component ... lore) {
        if (lore.length == 0) {
            return this;
        }
        return this.addDescription("lore", 0, lore);
    }

    public ItemTemplate addDescription(String name, int priority, Component ... description) {
        if (description.length < 1) {
            return this;
        }
        this.description.put(name, new DescriptionSection(priority, description));
        return this;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemTemplate setSlot(int slotX, int slotY) {
        return this.setSlot(ItemTemplate.slotFromXY(slotX, slotY));
    }

    public ItemTemplate setSlot(int slot) {
        this.slot = slot;
        return this;
    }

    public ItemTemplate setItemType(ItemType type) {
        this.type = type;
        return this;
    }

    public int getAmount() {
        return this.amount;
    }

    public ItemTemplate setAmount(int amount) {
        this.amount = Math.clamp((long)amount, 1, 64);
        return this;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public ItemTemplate setGlowing(boolean enable) {
        this.glowing = enable;
        return this;
    }

    public boolean hasNoTooltip() {
        return this.noTooltip;
    }

    public ItemTemplate setNoTooltip(boolean value) {
        this.noTooltip = value;
        return this;
    }

    public ItemTemplate setCompareKey(String key) {
        this.compareKey = key;
        return this;
    }

    public String getCompareKey() {
        return this.compareKey == null ? "" : this.compareKey;
    }

    public boolean isCompareKeyEqual(StackHandle other) {
        return ItemTemplate.isCompareKeyEqual(other, this.compareKey);
    }

    public static boolean isCompareKeyEqual(StackHandle stack, String compareKey) {
        if (compareKey == null) {
            return false;
        }
        return stack.compareKey().equals(compareKey);
    }

    public ItemTemplate setLeatherColor(@Nullable TextColor color) {
        this.leatherColor = color;
        return this;
    }

    @Nullable
    public TextColor getLeatherColor() {
        return this.leatherColor;
    }

    public ItemTemplate cooldownGroup(Key cooldownGroup) {
        this.cooldownGroup = cooldownGroup;
        return this;
    }

    @Nullable
    public Key getCooldownGroup() {
        return this.cooldownGroup;
    }

    public ItemTemplate addEnchantment(Key enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public Map<Key, Integer> getEnchantments() {
        return this.enchantments;
    }

    public ItemTemplate setDamage(int byAmount) {
        this.currentDamage = Math.max(this.currentDamage - byAmount, 0);
        return this;
    }

    public int getDamage() {
        return this.currentDamage;
    }

    public ItemTemplate setMaxDamage(@Nullable Integer damage) {
        this.maxDamage = damage;
        this.currentDamage = this.maxDamage == null ? 0 : this.maxDamage;
        return this;
    }

    @Nullable
    public Integer getMaxDamage() {
        return this.maxDamage;
    }

    public ItemTemplate setMaxStackSize(int stackSize) {
        this.maxStackSize = Math.clamp((long)stackSize, 1, 64);
        return this;
    }

    public Integer getMaxStackSize() {
        return this.maxStackSize;
    }

    public ItemTemplate resetMaxStackSize() {
        this.maxStackSize = null;
        return this;
    }

    public ItemTemplate setCustomModelData(String data) {
        this.customModelData = data;
        return this;
    }

    public String getCustomModelData() {
        return this.customModelData;
    }

    public ItemTemplate setTexturedVariant(ItemTemplate item) {
        this.texturedVariant = item;
        return this;
    }

    public boolean isEmpty() {
        return this.type.isAir();
    }

    public ItemType getItemType() {
        return this.type;
    }

    public ItemTemplate copy() {
        ItemTemplate copy = new ItemTemplate(this.slot, this.type, this.name, new Component[0]);
        copy.description.putAll(this.description);
        copy.amount = this.amount;
        copy.glowing = this.glowing;
        copy.noTooltip = this.noTooltip;
        copy.compareKey = this.compareKey;
        copy.enchantments.putAll(this.enchantments);
        copy.leatherColor = this.leatherColor;
        copy.maxDamage = this.maxDamage;
        copy.currentDamage = this.currentDamage;
        copy.customModelData = this.customModelData;
        copy.texturedVariant = this.texturedVariant == null ? null : this.texturedVariant.copy();
        copy.cooldownGroup = this.cooldownGroup;
        return copy;
    }

    public ItemTemplate copyToSlot(int slotX, int slotY) {
        return this.copyToSlot(ItemTemplate.slotFromXY(slotX, slotY));
    }

    public ItemTemplate copyToSlot(int slot) {
        ItemTemplate copy = this.copy();
        copy.slot = slot;
        return copy;
    }

    public ItemTemplate setExtraData(TagDataStorage value) {
        this.extraData = value;
        return this;
    }

    public TagDataStorage getExtraData() {
        return this.extraData;
    }

    public StackHandle buildItem() {
        return StackHandle.createFromTemplate(this, true);
    }

    public List<Component> buildDescriptionList() {
        ArrayList<Component> descriptionList = new ArrayList<Component>();
        this.description.values().stream().sorted(Comparator.comparingInt(a -> a.priority)).forEach(section -> {
            descriptionList.addAll(Arrays.stream(section.text).map(c -> c.colorIfAbsent(NamedTextColor.WHITE).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE)).toList());
            descriptionList.add(Component.text(" "));
        });
        if (!descriptionList.isEmpty()) {
            descriptionList.removeLast();
        }
        return descriptionList;
    }

    public static int slotFromXY(int slotX, int slotY) {
        return 9 * slotY + slotX;
    }

    public static ItemTemplate createColoredLeather(TextColor color, ItemType leatherItemType) {
        if (!LEATHER_ARMOR.contains(leatherItemType)) {
            leatherItemType = ItemType.of("minecraft:leather_chestplate");
        }
        ItemTemplate item = new ItemTemplate(leatherItemType, Component.text(color.asHexString()).color(color), new Component[0]);
        item.setLeatherColor(color);
        return item;
    }

    record DescriptionSection(int priority, Component[] text) {
    }
}

