/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.menu;

import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.papermc.paper.scoreboard.numbers.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.Nullable;

public class SidebarHUD {
    private final Set<UUID> subscribers;
    private final Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
    private final Objective sidebar;

    public SidebarHUD(Component initialTitle) {
        this.sidebar = this.board.registerNewObjective("info", Criteria.DUMMY, initialTitle);
        this.sidebar.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.sidebar.numberFormat(NumberFormat.blank());
        this.subscribers = new HashSet<UUID>();
        for (int i = 0; i < 15; ++i) {
            Team team = this.board.registerNewTeam("LINE_" + i);
            team.addEntry(this.getEntry(i));
            this.setText(i, null);
        }
    }

    public void clear() {
        for (int i = 0; i < 15; ++i) {
            this.setText(i, null);
        }
    }

    public void applyToPlayer(Player player) {
        this.subscribers.add(player.getUniqueId());
        player.setScoreboard(this.board);
    }

    public void removeFromPlayer(Player player) {
        this.subscribers.remove(player.getUniqueId());
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }

    public void setTitle(Component title) {
        this.sidebar.displayName(title);
    }

    public void setText(int lineNumber, @Nullable Component text) {
        if (lineNumber < 0 || lineNumber > 14) {
            ConsoleMessenger.warn("Line index " + lineNumber + " out of range for text display (use 0-14)");
            return;
        }
        Team team = this.board.getTeam("LINE_" + lineNumber);
        team.prefix(text);
        if (text == null) {
            this.board.resetScores(this.getEntry(lineNumber));
        } else {
            this.sidebar.getScore(this.getEntry(lineNumber)).setScore(0);
        }
    }

    public boolean isAppliedToPlayer(Player player) {
        return this.subscribers.contains(player.getUniqueId());
    }

    public void removeAll() {
        for (UUID sub : this.subscribers) {
            Player player = Bukkit.getPlayer((UUID)sub);
            if (player == null) continue;
            player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        }
        this.subscribers.clear();
    }

    private String getEntry(int lineNumber) {
        if (lineNumber < 0 || lineNumber > 14) {
            return "";
        }
        return ChatColor.values()[lineNumber].toString();
    }
}

