/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.menu;

import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.ScoreboardData;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;

public class SidebarTemplater {
    private static final Pattern ARG_PATTERN = Pattern.compile("\\{[a-zA-Z0-9_]+}");

    public static Component title(ScoreboardData.SidebarTemplate template, PlayerHandle player) {
        Component title = Component.empty();
        Component[] titleComponents = BingoMessage.convertForPlayer(template.title(), player, new Component[0]);
        if (titleComponents.length > 0) {
            title = titleComponents[0];
        }
        return title;
    }

    public static List<Component> sidebarComponents(ScoreboardData.SidebarTemplate template, PlayerHandle forPlayer) {
        int lineIndex = 0;
        ArrayList<Component> components = new ArrayList<Component>();
        for (String line : template.lines()) {
            line = BingoMessage.preParseString(forPlayer, line);
            Matcher matcher = ARG_PATTERN.matcher(line);
            boolean appendToLastComponent = false;
            while (matcher.find()) {
                String match = matcher.group();
                String key = match.replace("{", "").replace("}", "");
                String[] lineParts = line.split(Pattern.quote(match), 2);
                String beforeMatch = lineParts[0];
                String before = BingoMessage.convertConfigStringToSingleMini(beforeMatch);
                Component componentToAdd = appendToLastComponent ? (Component)components.removeLast() : Component.empty();
                componentToAdd = componentToAdd.append((Component)ComponentUtils.MINI_BUILDER.deserialize(before));
                appendToLastComponent = true;
                Component[] argument = template.arguments().getOrDefault(key, new Component[0]);
                if (argument.length != 0) {
                    for (Component arg : argument) {
                        if (15 - components.size() - (template.lines().length - lineIndex) > 0) {
                            components.add(componentToAdd.append(arg));
                            componentToAdd = Component.empty();
                            continue;
                        }
                        break;
                    }
                } else {
                    components.add(componentToAdd);
                }
                line = line.substring(beforeMatch.length() + match.length());
            }
            if (line.isEmpty()) {
                ++lineIndex;
                continue;
            }
            Object rightSide = ComponentUtils.MINI_BUILDER.deserialize(line);
            if (appendToLastComponent) {
                components.set(components.size() - 1, ((Component)components.getLast()).append((Component)rightSide));
            } else {
                components.add((Component)rightSide);
            }
            ++lineIndex;
        }
        return components;
    }
}

