/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.util;

import io.github.steaf23.bingoreloaded.lib.api.AdvancementHandle;
import io.github.steaf23.bingoreloaded.lib.api.EntityType;
import io.github.steaf23.bingoreloaded.lib.api.StatisticHandle;
import io.github.steaf23.bingoreloaded.lib.api.item.ItemType;
import io.github.steaf23.bingoreloaded.lib.util.TinyCaps;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class ComponentUtils {
    public static final MiniMessage MINI_BUILDER = MiniMessage.builder().tags(TagResolver.builder().resolvers(StandardTags.defaults(), TinyCaps.TAG_RESOLVER).build()).build();

    public static Component[] createComponentsFromString(String ... strings) {
        return Arrays.stream(strings).map(s -> LegacyComponentSerializer.legacySection().deserialize((String)s)).toList().toArray(new Component[0]);
    }

    public static Component itemName(ItemType item) {
        return Component.translatable(ComponentUtils.itemKey(item));
    }

    public static Component advancementTitle(@NotNull AdvancementHandle advancement) {
        return Component.translatable(ComponentUtils.advancementKey(advancement) + ".title");
    }

    public static Component advancementDescription(@NotNull AdvancementHandle advancement) {
        return Component.translatable(ComponentUtils.advancementKey(advancement) + ".description");
    }

    public static Component statistic(StatisticHandle statistic, Component ... with) {
        return Component.translatable(ComponentUtils.statisticKey(statistic), (ComponentLike[])with);
    }

    public static Component entityName(EntityType entity) {
        return Component.translatable(ComponentUtils.entityKey(entity));
    }

    private static String advancementKey(@NotNull AdvancementHandle advancement) {
        String result;
        result = switch (result = advancement.key().value().replace("/", ".")) {
            case "husbandry.obtain_netherite_hoe" -> "husbandry.netherite_hoe";
            case "husbandry.bred_all_animals" -> "husbandry.breed_all_animals";
            case "adventure.read_power_of_chiseled_bookshelf" -> "adventure.read_power_from_chiseled_bookshelf";
            default -> result;
        };
        return "advancements." + result;
    }

    private static String statisticKey(StatisticHandle statistic) {
        String prefix = statistic.isSubStatistic() ? "stat_type.minecraft." : "stat.minecraft.";
        String result = statistic.translationKey();
        return !result.isEmpty() ? prefix + result : statistic.statisticType().key().asString();
    }

    private static String itemKey(ItemType item) {
        return (item.isBlock() ? "block" : "item") + ".minecraft." + item.key().value();
    }

    private static String entityKey(EntityType entity) {
        return "entity.minecraft." + entity.key().value();
    }
}

