/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.util;

import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.lib.util.SimpleLog;
import java.io.File;

public class DebugLogger {
    private static SimpleLog logger;
    private static boolean useLogging;

    public static void addLog(String message) {
        if (useLogging && logger != null) {
            logger.log(message);
        }
    }

    public static void setupLogger(ServerSoftware platform) {
        logger = new SimpleLog(new File(platform.getDataFolder(), "log/debug.log"));
        ConsoleMessenger.log("Set up debug logger for " + platform.getExtensionInfo().name());
    }

    public static void stopLogger() {
        logger.close();
    }

    public static void setLoggingEnabled(boolean enabled) {
        useLogging = enabled;
        DebugLogger.addLog(enabled ? "Enabled debug logging" : "Disabled debug logging");
    }

    static {
        useLogging = false;
    }
}

