/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class MultilineComponent {
    private TextColor color = null;
    private final List<TextDecoration> decoration = new ArrayList<TextDecoration>();
    private final Component[] components;

    private MultilineComponent(Component ... components) {
        this.components = components;
    }

    public static MultilineComponent of(Component ... components) {
        return new MultilineComponent(components);
    }

    public static Component[] from(TextColor color, List<TextDecoration> decoration, Component ... components) {
        return new MultilineComponent(components).color(color).decorate((TextDecoration[])decoration.toArray(TextDecoration[]::new)).build();
    }

    public static Component[] from(TextColor color, TextDecoration decoration, Component ... components) {
        return new MultilineComponent(components).color(color).decorate(decoration).build();
    }

    public MultilineComponent color(TextColor color) {
        this.color = color;
        return this;
    }

    public MultilineComponent decorate(TextDecoration ... decorations) {
        this.decoration.addAll(Arrays.stream(decorations).toList());
        return this;
    }

    public Component[] build() {
        return (Component[])Arrays.stream(this.components).map(c -> (Component)c.color(this.color).decorate((TextDecoration[])this.decoration.toArray(TextDecoration[]::new))).toArray(Component[]::new);
    }
}

