/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.util;

import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTByte;
import com.github.retrooper.packetevents.protocol.nbt.NBTByteArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTDouble;
import com.github.retrooper.packetevents.protocol.nbt.NBTFloat;
import com.github.retrooper.packetevents.protocol.nbt.NBTInt;
import com.github.retrooper.packetevents.protocol.nbt.NBTIntArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.github.retrooper.packetevents.protocol.nbt.NBTLong;
import com.github.retrooper.packetevents.protocol.nbt.NBTLongArray;
import com.github.retrooper.packetevents.protocol.nbt.NBTShort;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.Tag;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagList;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagTree;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;

public class NBTConverter {
    public static Tag.CompoundTag tagFromPacketEventsNBT(NBTCompound input) {
        return (Tag.CompoundTag)NBTConverter.decodeTag((NBT)input);
    }

    private static Tag<?> decodeTag(NBT in) {
        NBT nBT = in;
        Objects.requireNonNull(nBT);
        NBT nBT2 = nBT;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NBTByte.class, NBTShort.class, NBTInt.class, NBTLong.class, NBTFloat.class, NBTDouble.class, NBTByteArray.class, NBTString.class, NBTIntArray.class, NBTLongArray.class, NBTList.class, NBTCompound.class}, (Object)nBT2, n)) {
            case 0: {
                NBTByte nbtByte = (NBTByte)nBT2;
                return new Tag.ByteTag(nbtByte.getAsByte());
            }
            case 1: {
                NBTShort nbtShort = (NBTShort)nBT2;
                return new Tag.ShortTag(nbtShort.getAsShort());
            }
            case 2: {
                NBTInt nbtInt = (NBTInt)nBT2;
                return new Tag.IntegerTag(nbtInt.getAsInt());
            }
            case 3: {
                NBTLong nbtLong = (NBTLong)nBT2;
                return new Tag.LongTag(nbtLong.getAsLong());
            }
            case 4: {
                NBTFloat nbtFloat = (NBTFloat)nBT2;
                return new Tag.FloatTag(nbtFloat.getAsFloat());
            }
            case 5: {
                NBTDouble nbtDouble = (NBTDouble)nBT2;
                return new Tag.DoubleTag(nbtDouble.getAsDouble());
            }
            case 6: {
                NBTByteArray nbtByteArray = (NBTByteArray)nBT2;
                return new Tag.ByteArrayTag(nbtByteArray.getValue());
            }
            case 7: {
                NBTString nbtString = (NBTString)nBT2;
                return new Tag.StringTag(nbtString.getValue());
            }
            case 8: {
                NBTIntArray nbtIntArray = (NBTIntArray)nBT2;
                return new Tag.IntegerArrayTag(nbtIntArray.getValue());
            }
            case 9: {
                NBTLongArray nbtLongArray = (NBTLongArray)nBT2;
                return new Tag.LongArrayTag(nbtLongArray.getValue());
            }
            case 10: {
                NBTList nbtList = (NBTList)nBT2;
                TagList list = new TagList();
                for (NBT nbt : nbtList.getTags()) {
                    list.addTag(NBTConverter.decodeTag(nbt));
                }
                return new Tag.ListTag(list);
            }
            case 11: {
                NBTCompound nbtCompound = (NBTCompound)nBT2;
                Map map = nbtCompound.getTags();
                TagTree tree = new TagTree();
                for (String name : map.keySet()) {
                    tree.putChild(name, NBTConverter.decodeTag((NBT)map.get(name)));
                }
                return new Tag.CompoundTag(tree);
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(in));
    }
}

