/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;

public class SimpleLog {
    private BufferedWriter writer;

    public SimpleLog(File location) {
        try {
            if (!location.exists()) {
                location.getParentFile().mkdirs();
                location.createNewFile();
            }
            this.writer = new BufferedWriter(new FileWriter(location, true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void log(String message) {
        try {
            this.writer.write(String.valueOf(Instant.now()) + ": " + message);
            this.writer.newLine();
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

