/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.lib.util;

import io.github.steaf23.bingoreloaded.lib.util.ExtraMath;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;

public class TextColorGradient {
    Map<TextColor, Float> colors = new HashMap<TextColor, Float>();

    public TextColorGradient addColor(@NotNull TextColor color, float position) throws IllegalArgumentException {
        if ((double)position < 0.0 || (double)position > 1.0) {
            throw new IllegalArgumentException("position must be between 0.0 and 1.0.");
        }
        this.colors.put(color, Float.valueOf(position));
        return this;
    }

    public boolean removeColor(@NotNull TextColor color) {
        return this.colors.remove(color) != null;
    }

    public TextColor sample(float position) {
        if (this.colors.isEmpty()) {
            return NamedTextColor.WHITE;
        }
        if (this.colors.size() == 1) {
            return (TextColor)this.colors.keySet().stream().toList().getFirst();
        }
        List<TextColor> sortedColors = this.colors.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        TextColor leftColor = sortedColors.get(0);
        TextColor rightColor = sortedColors.get(1);
        for (int i = 0; i < sortedColors.size() - 1; ++i) {
            if (!(position >= this.colors.get(sortedColors.get(i)).floatValue()) || !(position <= this.colors.get(sortedColors.get(i + 1)).floatValue())) continue;
            leftColor = sortedColors.get(i);
            rightColor = sortedColors.get(i + 1);
        }
        float leftPosition = this.colors.get(leftColor).floatValue();
        float rightPosition = this.colors.get(rightColor).floatValue();
        float lerpValue = ExtraMath.map(position, leftPosition, rightPosition, 0.0f, 1.0f);
        return TextColorGradient.lerpChatColor(leftColor, rightColor, lerpValue);
    }

    public static TextColor lerpChatColor(@NotNull TextColor left, @NotNull TextColor right, float value) {
        int red = (int)ExtraMath.lerp(left.red(), right.red(), value);
        int green = (int)ExtraMath.lerp(left.green(), right.green(), value);
        int blue = (int)ExtraMath.lerp(left.blue(), right.blue(), value);
        return TextColor.color(Math.clamp((long)red, 0, 255), Math.clamp((long)green, 0, 255), Math.clamp((long)blue, 0, 255));
    }
}

