/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.menu;

import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.lib.menu.InfoMenu;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.player.team.SoloTeamManager;
import io.github.steaf23.bingoreloaded.player.team.TeamManager;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class BingoGameInfoMenu
extends InfoMenu {
    private final Map<String, Integer> teamScores;
    private final BingoSession session;
    private final boolean showPlayerNames;
    private static final Component PLAYER_PREFIX = ComponentUtils.MINI_BUILDER.deserialize("<gray><bold> \u2517 </bold></gray><white>");

    public BingoGameInfoMenu(BingoSession session, boolean showPlayerNames) {
        this.session = session;
        this.showPlayerNames = showPlayerNames;
        this.teamScores = new HashMap<String, Integer>();
    }

    public void updateWinScore(BingoSettings settings) {
        String goal = "-";
        switch (settings.mode()) {
            case HOTSWAP: {
                if (!settings.useScoreAsWinCondition()) break;
                goal = Integer.toString(settings.hotswapGoal());
                break;
            }
            case COMPLETE: {
                if (!settings.useScoreAsWinCondition()) break;
                goal = Integer.toString(settings.completeGoal());
                break;
            }
            case REGULAR: {
                goal = "-----";
                break;
            }
            case LOCKOUT: {
                goal = Integer.toString(settings.size().fullCardSize);
            }
        }
        this.addField("win_goal", Component.text(goal));
    }

    public void updateTeamScores() {
        if (!this.session.isRunning()) {
            return;
        }
        for (BingoTeam t : this.session.teamManager.getActiveTeams()) {
            this.teamScores.put(t.getIdentifier(), t.getCompleteCount());
        }
        ArrayList teamInfo = new ArrayList();
        ArrayList teamInfoCondensed = new ArrayList();
        TeamManager teamManager = this.session.teamManager;
        boolean useFullTeamDisplay = this.showPlayerNames && !(teamManager instanceof SoloTeamManager);
        teamManager.getActiveTeams().getTeams().stream().sorted(Comparator.comparingInt(BingoTeam::getCompleteCount).reversed()).forEach(team -> {
            Component teamScore = teamManager instanceof SoloTeamManager ? team.getColoredName() : team.getPrefix();
            teamScore = teamScore.append(Component.text(": ", (TextColor)NamedTextColor.WHITE).append(Component.text(this.teamScores.get(team.getIdentifier())).decorate(TextDecoration.BOLD)));
            teamInfo.add(teamScore);
            teamInfoCondensed.add(teamScore);
            if (useFullTeamDisplay) {
                for (BingoParticipant player : team.getMembers()) {
                    teamInfo.add(PLAYER_PREFIX.append(player.getDisplayName()));
                }
            }
        });
        this.addField("team_info", (Component[])teamInfo.toArray(Component[]::new));
        this.addField("team_info_condensed", (Component[])teamInfoCondensed.toArray(Component[]::new));
    }

    public void setup(BingoSettings settings) {
        this.teamScores.clear();
        this.updateTeamScores();
        this.updateWinScore(settings);
    }
}

