/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.menu;

import io.github.steaf23.bingoreloaded.data.config.BingoConfigurationData;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.lib.menu.InfoMenu;
import io.github.steaf23.bingoreloaded.player.EffectOptionFlags;
import io.github.steaf23.bingoreloaded.settings.BingoGamemode;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.jetbrains.annotations.NotNull;

public class BingoSettingsInfoMenu
extends InfoMenu {
    public BingoSettingsInfoMenu() {
        this.setStatus(Component.empty());
    }

    public void setStatus(@NotNull Component status) {
        this.addField("status", status.color(NamedTextColor.RED));
    }

    public void updateSettings(@NotNull BingoSettings settings, BingoConfigurationData config) {
        this.addField("gamemode", settings.mode().asComponent());
        this.addField("card_size", settings.size().asComponent());
        this.addField("kit", settings.kit().getDisplayName());
        this.addField("team_size", config.getOptionValue(BingoOptions.SINGLE_PLAYER_TEAMS) != false ? Component.text("1").color(NamedTextColor.AQUA) : Component.text(Integer.toString(settings.maxTeamSize())));
        this.addField("duration", settings.useCountdown() ? Component.text(Integer.toString(settings.countdownDuration())) : Component.text("\u221e").color(NamedTextColor.AQUA));
        this.addField("effects", EffectOptionFlags.effectsToText(settings.effects()));
        this.addField("seed", Component.text(settings.seed()));
        this.addField("goal", Component.text(settings.mode() == BingoGamemode.COMPLETE ? settings.completeGoal() : settings.hotswapGoal()));
        this.addField("expire_hotswap", settings.expireHotswapTasks() ? Component.text("\u2714").color(NamedTextColor.GREEN) : Component.text("\u2715").color(NamedTextColor.RED));
        this.addField("separate_cards", settings.differentCardPerTeam() ? Component.text("\u2714").color(NamedTextColor.GREEN) : Component.text("\u2715").color(NamedTextColor.RED));
    }
}

