/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.placeholder;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.BingoStatData;
import io.github.steaf23.bingoreloaded.data.BingoStatType;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gameloop.GameManager;
import io.github.steaf23.bingoreloaded.gameloop.phase.BingoGame;
import io.github.steaf23.bingoreloaded.gameloop.phase.GamePhase;
import io.github.steaf23.bingoreloaded.lib.api.PlatformResolver;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.placeholder.BingoPlaceholderFormatter;
import io.github.steaf23.bingoreloaded.placeholder.BingoReloadedPlaceholder;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import io.github.steaf23.bingoreloaded.util.timer.GameTimer;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BingoReloadedPlaceholderExpansion
extends PlaceholderExpansion {
    private final BingoReloaded extension;
    private final BingoPlaceholderFormatter formatter;
    private final ServerSoftware server;

    public BingoReloadedPlaceholderExpansion(ServerSoftware server, BingoReloaded extension) {
        this.server = server;
        this.extension = extension;
        this.formatter = new BingoPlaceholderFormatter();
    }

    @NotNull
    public String getIdentifier() {
        return "bingoreloaded";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", PlatformResolver.get().getExtensionInfo().authors());
    }

    @NotNull
    public String getVersion() {
        return PlatformResolver.get().getExtensionInfo().version();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        Component placeholderComponent;
        BingoReloadedPlaceholder placeholder = BingoReloadedPlaceholder.fromString(params);
        if (placeholder == null) {
            ConsoleMessenger.error("unexpected placeholder '" + params + "' not found in bingo reloaded.");
            return null;
        }
        TextComponent defaultComponent = Component.text("-");
        switch (placeholder) {
            default: {
                throw new MatchException(null, null);
            }
            case CREATED_SESSION: {
                Component component;
                String sessionName = params.replace(BingoReloadedPlaceholder.CREATED_SESSION.getName(), "");
                BingoSession session = this.extension.getGameManager().getSession(sessionName);
                if (session == null) {
                    component = Component.empty();
                    break;
                }
                component = Component.text(sessionName);
                break;
            }
            case COUNT_SESSION_PLAYERS: {
                Component component;
                String sessionName = params.replace(BingoReloadedPlaceholder.COUNT_SESSION_PLAYERS.getName(), "");
                BingoSession session = this.extension.getGameManager().getSession(sessionName);
                if (session == null) {
                    component = Component.empty();
                    break;
                }
                component = Component.text(session.teamManager.getParticipants().size());
                break;
            }
            case TEAM_FULL: {
                Component component = this.getPlayerTeamPlaceholder(player, true, true);
                break;
            }
            case TEAM_COLOR: {
                Component component = this.getPlayerTeamPlaceholder(player, false, true);
                break;
            }
            case TEAM_NAME: {
                Component component = this.getPlayerTeamPlaceholder(player, true, false);
                break;
            }
            case CURRENT_TASKS_TEAM: {
                Component component;
                BingoTeam team = this.getPlayerTeam(player);
                if (team == null) {
                    component = defaultComponent;
                    break;
                }
                component = Component.text(team.getCompleteCount());
                break;
            }
            case CURRENT_TASKS_PLAYER: {
                Component component;
                BingoParticipant participant = this.getParticipant(player);
                if (participant == null) {
                    component = defaultComponent;
                    break;
                }
                component = Component.text(participant.getAmountOfTaskCompleted());
                break;
            }
            case CURRENT_TIME: {
                Component component;
                BingoSession session = this.getSession(player);
                if (session == null) {
                    component = defaultComponent;
                    break;
                }
                GamePhase gamePhase = session.phase();
                if (gamePhase instanceof BingoGame) {
                    BingoGame game = (BingoGame)gamePhase;
                    component = GameTimer.getTimeAsComponent(game.getGameTime());
                    break;
                }
                component = defaultComponent;
                break;
            }
            case GAME_STATUS: {
                ConsoleMessenger.error("placeholder bingoreloaded_game_status is not implemented yet!");
                Component component = defaultComponent;
                break;
            }
            case SETTING_GAMEMODE: {
                Component component;
                BingoSettings settings = this.getSettings(player);
                if (settings == null) {
                    component = defaultComponent;
                    break;
                }
                component = settings.mode().asComponent();
                break;
            }
            case SETTING_CARDSIZE: {
                Component component;
                BingoSettings settings = this.getSettings(player);
                if (settings == null) {
                    component = defaultComponent;
                    break;
                }
                component = settings.size().asComponent();
                break;
            }
            case SETTING_CARDNAME: {
                Component component;
                BingoSettings settings = this.getSettings(player);
                if (settings == null) {
                    component = defaultComponent;
                    break;
                }
                component = Component.text(settings.card());
                break;
            }
            case SETTING_KIT: {
                Component component;
                BingoSettings settings = this.getSettings(player);
                if (settings == null) {
                    component = defaultComponent;
                    break;
                }
                component = settings.kit().getDisplayName();
                break;
            }
            case SETTING_DURATION: {
                Component component;
                BingoSettings settings = this.getSettings(player);
                if (settings == null) {
                    component = defaultComponent;
                    break;
                }
                if (settings.useCountdown()) {
                    component = Component.text(settings.countdownDuration());
                    break;
                }
                component = defaultComponent;
                break;
            }
            case SETTING_EFFECTS: {
                ConsoleMessenger.error("placeholder bingoreloaded_setting_effect is not implemented yet!");
                Component component = defaultComponent;
                break;
            }
            case SETTING_HOTSWAP_WINSCORE: {
                Component component;
                BingoSettings settings = this.getSettings(player);
                if (settings == null) {
                    component = defaultComponent;
                    break;
                }
                if (settings.useScoreAsWinCondition()) {
                    component = Component.text(settings.hotswapGoal());
                    break;
                }
                component = defaultComponent;
                break;
            }
            case SETTING_HOTSWAP_EXPIRE: {
                Component component;
                BingoSettings settings = this.getSettings(player);
                if (settings == null) {
                    component = defaultComponent;
                    break;
                }
                component = Component.text(settings.expireHotswapTasks());
                break;
            }
            case SETTING_COMPLETE_WINSCORE: {
                Component component;
                BingoSettings settings = this.getSettings(player);
                if (settings == null) {
                    component = defaultComponent;
                    break;
                }
                if (settings.useScoreAsWinCondition()) {
                    component = Component.text(settings.completeGoal());
                    break;
                }
                component = defaultComponent;
                break;
            }
            case SETTING_SEED: {
                Component component;
                BingoSettings settings = this.getSettings(player);
                if (settings == null) {
                    component = defaultComponent;
                    break;
                }
                component = Component.text(settings.seed());
                break;
            }
            case SETTING_TEAMSIZE: {
                Component component;
                BingoSettings settings = this.getSettings(player);
                if (settings == null) {
                    component = defaultComponent;
                    break;
                }
                component = Component.text(settings.maxTeamSize());
                break;
            }
            case SETTING_SEPARATE_CARDS: {
                Component component;
                BingoSettings settings = this.getSettings(player);
                if (settings == null) {
                    component = defaultComponent;
                    break;
                }
                component = Component.text(settings.differentCardPerTeam());
                break;
            }
            case SESSION_NAME: {
                Component component = this.getPlayerSessionPlaceholder(player);
                break;
            }
            case GAMES_WINS: {
                Component component = this.getPlayerStatPlaceholder(player, BingoStatType.WINS);
                break;
            }
            case GAMES_LOSSES: {
                Component component = this.getPlayerStatPlaceholder(player, BingoStatType.LOSSES);
                break;
            }
            case GAMES_PLAYED: {
                Component component = this.getPlayerStatPlaceholder(player, BingoStatType.PLAYED);
                break;
            }
            case TASKS_COMPLETED: {
                Component component = this.getPlayerStatPlaceholder(player, BingoStatType.TASKS);
                break;
            }
            case TASK_COMPLETED_RECORD: {
                Component component = this.getPlayerStatPlaceholder(player, BingoStatType.RECORD_TASKS);
                break;
            }
            case ITEM_USES_WAND: {
                Component component = placeholderComponent = this.getPlayerStatPlaceholder(player, BingoStatType.WAND_USES);
            }
        }
        if (placeholder == BingoReloadedPlaceholder.TEAM_FULL) {
            return LegacyComponentSerializer.legacySection().serialize(placeholderComponent) + "\u00a7r";
        }
        return LegacyComponentSerializer.legacySection().serialize(BingoMessage.createPhrase(this.getPlaceholderFormat(placeholder), placeholderComponent)) + "\u00a7r";
    }

    private Component getPlayerTeamPlaceholder(OfflinePlayer player, boolean getName, boolean getColor) {
        GameManager gameManager = this.extension.getGameManager();
        TextComponent noTeamPlaceholder = Component.empty();
        PlayerHandle onlinePlayer = this.server.getPlayerFromUniqueId(player.getUniqueId());
        if (onlinePlayer != null) {
            BingoSession session = gameManager.getSessionFromWorld(onlinePlayer.world());
            if (session == null) {
                return noTeamPlaceholder;
            }
            BingoParticipant participant = session.teamManager.getPlayerAsParticipant(onlinePlayer);
            if (participant == null || participant.getTeam() == null) {
                return noTeamPlaceholder;
            }
            return this.placeholderFromTeam(participant.getTeam(), getName, getColor);
        }
        for (String sessionName : gameManager.getSessionNames()) {
            BingoSession session = gameManager.getSession(sessionName);
            if (session == null) {
                return noTeamPlaceholder;
            }
            for (BingoParticipant participant : session.teamManager.getParticipants()) {
                if (!participant.getId().equals(player.getUniqueId()) || participant.getTeam() == null) continue;
                return this.placeholderFromTeam(participant.getTeam(), getName, getColor);
            }
        }
        return noTeamPlaceholder;
    }

    private Component getPlayerStatPlaceholder(OfflinePlayer player, BingoStatType statType) {
        BingoStatData statData = new BingoStatData(this.server);
        return Component.text(statData.getPlayerStat(player.getUniqueId(), statType));
    }

    private Component placeholderFromTeam(@NotNull BingoTeam team, boolean getName, boolean getColor) {
        if (getColor && getName) {
            return BingoMessage.createPhrase(this.getPlaceholderFormat(BingoReloadedPlaceholder.TEAM_FULL).replace("{0}", "<" + team.getColor().toString() + ">").replace("{1}", "<0>"), this.placeholderFromTeam(team, true, false));
        }
        if (getColor) {
            return Component.empty();
        }
        if (getName) {
            return BingoMessage.createPhrase(this.getPlaceholderFormat(BingoReloadedPlaceholder.TEAM_NAME), team.getName());
        }
        return Component.empty();
    }

    private Component getPlayerSessionPlaceholder(OfflinePlayer player) {
        BingoSession session = this.getSession(player);
        TextComponent noSessionPlaceholder = Component.empty();
        if (session == null) {
            return noSessionPlaceholder;
        }
        return BingoMessage.createPhrase(this.getPlaceholderFormat(BingoReloadedPlaceholder.SESSION_NAME), Component.text(this.extension.getGameManager().getNameOfSession(session)));
    }

    private String getPlaceholderFormat(BingoReloadedPlaceholder placeholder) {
        return this.formatter.format(placeholder);
    }

    @Nullable
    private BingoSession getSession(OfflinePlayer player) {
        GameManager gameManager = this.extension.getGameManager();
        PlayerHandle onlinePlayer = this.server.getPlayerFromUniqueId(player.getUniqueId());
        if (onlinePlayer != null) {
            return gameManager.getSessionFromWorld(onlinePlayer.world());
        }
        for (String sessionName : gameManager.getSessionNames()) {
            BingoSession session = gameManager.getSession(sessionName);
            for (BingoParticipant participant : session.teamManager.getParticipants()) {
                if (!participant.getId().equals(player.getUniqueId()) || participant.getTeam() == null) continue;
                return session;
            }
        }
        return null;
    }

    @Nullable
    private BingoParticipant getParticipant(OfflinePlayer player) {
        GameManager gameManager = this.extension.getGameManager();
        PlayerHandle onlinePlayer = this.server.getPlayerFromUniqueId(player.getUniqueId());
        if (onlinePlayer != null) {
            BingoSession session = gameManager.getSessionFromWorld(onlinePlayer.world());
            if (session == null) {
                return null;
            }
            return session.teamManager.getPlayerAsParticipant(onlinePlayer);
        }
        for (String sessionName : gameManager.getSessionNames()) {
            BingoSession session = gameManager.getSession(sessionName);
            for (BingoParticipant participant : session.teamManager.getParticipants()) {
                if (!participant.getId().equals(player.getUniqueId()) || participant.getTeam() == null) continue;
                return participant;
            }
        }
        return null;
    }

    @Nullable
    private BingoTeam getPlayerTeam(OfflinePlayer player) {
        BingoParticipant participant = this.getParticipant(player);
        if (participant == null) {
            return null;
        }
        return participant.getTeam();
    }

    @Nullable
    private BingoSettings getSettings(OfflinePlayer player) {
        BingoSession session = this.getSession(player);
        if (session == null) {
            return null;
        }
        return session.settingsBuilder.view();
    }
}

