/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.player;

import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.player.EffectOptionFlags;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import io.github.steaf23.bingoreloaded.tasks.data.ItemTask;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BingoParticipant
extends ForwardingAudience.Single {
    public BingoSession getSession();

    @Nullable
    public BingoTeam getTeam();

    public void setTeam(@Nullable BingoTeam var1);

    public UUID getId();

    public Optional<PlayerHandle> sessionPlayer();

    public String getName();

    public Component getDisplayName();

    public void showDeathMatchTask(ItemTask var1);

    public void showCard(ItemTask var1);

    public boolean alwaysActive();

    default public int getAmountOfTaskCompleted() {
        if (this.getTeam() == null) {
            return 0;
        }
        Optional<TaskCard> card = this.getTeam().getCard();
        return card.map(taskCard -> taskCard.getCompleteCount(this)).orElse(0);
    }

    default public Optional<TaskCard> getCard() {
        if (this.getTeam() == null) {
            return Optional.empty();
        }
        return this.getTeam().getCard();
    }

    public void giveBingoCard(int var1, @NotNull StackHandle var2);

    public void giveEffects(EnumSet<EffectOptionFlags> var1, int var2);

    public void takeEffects(boolean var1);

    public void giveKit(PlayerKit var1);
}

