/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.player;

import io.github.steaf23.bingoreloaded.BingoReloaded;
import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.BingoSound;
import io.github.steaf23.bingoreloaded.data.BingoStatType;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.gameloop.phase.BingoGame;
import io.github.steaf23.bingoreloaded.lib.api.PotionEffectInstance;
import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.StatusEffectType;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import io.github.steaf23.bingoreloaded.lib.api.item.StackHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerInventoryHandle;
import io.github.steaf23.bingoreloaded.lib.data.core.tag.TagDataStorage;
import io.github.steaf23.bingoreloaded.lib.item.SerializableItem;
import io.github.steaf23.bingoreloaded.lib.util.ComponentUtils;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.EffectOptionFlags;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.settings.PlayerKit;
import io.github.steaf23.bingoreloaded.tasks.data.ItemTask;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BingoPlayer
implements BingoParticipant {
    public final String playerName;
    private BingoTeam team;
    private final BingoSession session;
    private final UUID playerId;
    private final Component displayName;
    private final ServerSoftware server;

    public BingoPlayer(PlayerHandle player, BingoSession session) {
        this.playerId = player.uniqueId();
        this.session = session;
        this.server = session.getGameManager().getPlatform();
        this.playerName = player.playerName();
        this.displayName = player.displayName();
        this.team = null;
    }

    @Override
    public Optional<PlayerHandle> sessionPlayer() {
        PlayerHandle player = this.server.getPlayerFromUniqueId(this.playerId);
        if (player == null || !this.session.hasPlayer(player)) {
            return Optional.empty();
        }
        return Optional.of(player);
    }

    @Override
    public String getName() {
        return this.playerName;
    }

    @Override
    public UUID getId() {
        return this.playerId;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public void giveKit(PlayerKit kit) {
        if (this.sessionPlayer().isEmpty()) {
            return;
        }
        PlayerHandle player = this.sessionPlayer().get();
        List<SerializableItem> items = kit.getItems(this.getTeam().getColor(), this.server);
        player.closeInventory();
        PlayerInventoryHandle inv = player.inventory();
        inv.clearContents();
        items.forEach(i -> {
            TagDataStorage store = i.stack().getStorage();
            store.setBoolean("kit_item", true);
            i.stack().setStorage(store);
            inv.setItem(i.slot(), i.stack());
        });
    }

    @Override
    public void giveBingoCard(int cardSlot, @NotNull StackHandle cardItem) {
        if (this.sessionPlayer().isEmpty()) {
            return;
        }
        PlayerHandle player = this.sessionPlayer().get();
        this.server.runTask(task -> {
            for (StackHandle itemStack : player.inventory().contents()) {
                if (!PlayerKit.CARD_ITEM.isCompareKeyEqual(itemStack)) continue;
                player.inventory().removeItem(itemStack);
                break;
            }
            StackHandle existingItem = player.inventory().getItem(cardSlot);
            player.inventory().setItem(cardSlot, cardItem);
            if (!existingItem.type().isAir()) {
                HashMap<Integer, StackHandle> leftOver = player.inventory().addItem(existingItem);
                for (StackHandle stack : leftOver.values()) {
                    player.world().dropItem(stack, player.position());
                }
            }
        });
    }

    @Override
    public void giveEffects(EnumSet<EffectOptionFlags> effects, int gracePeriod) {
        if (this.sessionPlayer().isEmpty()) {
            return;
        }
        this.takeEffects(false);
        PlayerHandle player = this.sessionPlayer().get();
        this.server.runTask(task -> {
            if (effects.contains((Object)EffectOptionFlags.NIGHT_VISION)) {
                player.addEffect(new PotionEffectInstance(StatusEffectType.of("minecraft:night_vision"), -1).setParticles(false));
            }
            if (effects.contains((Object)EffectOptionFlags.WATER_BREATHING)) {
                player.addEffect(new PotionEffectInstance(StatusEffectType.of("minecraft:water_breathing"), -1).setParticles(false));
            }
            if (effects.contains((Object)EffectOptionFlags.FIRE_RESISTANCE)) {
                player.addEffect(new PotionEffectInstance(StatusEffectType.of("minecraft:fire_resistance"), -1).setParticles(false));
            }
            if (effects.contains((Object)EffectOptionFlags.SPEED)) {
                player.addEffect(new PotionEffectInstance(StatusEffectType.of("minecraft:speed"), -1).setParticles(false));
            }
            player.addEffect(new PotionEffectInstance(StatusEffectType.of("minecraft:saturation"), 2).setAmplifier(100).setParticles(false));
            player.addEffect(new PotionEffectInstance(StatusEffectType.of("minecraft:regeneration"), 2).setAmplifier(100).setParticles(false));
            player.addEffect(new PotionEffectInstance(StatusEffectType.of("minecraft:resistance"), 20 * gracePeriod).setAmplifier(100).setParticles(false));
        });
    }

    @Override
    public void takeEffects(boolean force) {
        if (force) {
            PlayerHandle p = this.server.getPlayerFromUniqueId(this.playerId);
            if (p != null) {
                p.clearAllEffects();
            }
        } else {
            if (this.sessionPlayer().isEmpty()) {
                return;
            }
            this.sessionPlayer().get().clearAllEffects();
        }
    }

    @Override
    public void showDeathMatchTask(ItemTask task) {
        if (this.sessionPlayer().isEmpty()) {
            return;
        }
        this.sessionPlayer().get().sendMessage(BingoMessage.DEATHMATCH_ITEM.asPhrase(ComponentUtils.itemName(task.itemType())).color(NamedTextColor.GOLD));
    }

    @Override
    public void showCard(ItemTask deathMatchTask) {
        BingoTeam playerTeam = this.getTeam();
        if (playerTeam == null) {
            ConsoleMessenger.bug("Invalid team for player " + this.playerName + "!", (Object)this);
            return;
        }
        Optional<TaskCard> card = playerTeam.getCard();
        this.sessionPlayer().ifPresent(player -> {
            if (deathMatchTask != null) {
                this.showDeathMatchTask(deathMatchTask);
                return;
            }
            card.ifPresentOrElse(c -> c.showInventory((PlayerHandle)player), () -> BingoMessage.NO_PLAYER_CARD.sendToAudience((Audience)player, new Component[0]));
        });
    }

    @Override
    public boolean alwaysActive() {
        return false;
    }

    public void useGoUpWand(StackHandle wand, double wandCooldownSeconds, int downDistance, int upDistance, int platformLifetimeSeconds) {
        if (this.sessionPlayer().isEmpty()) {
            return;
        }
        PlayerHandle player = this.sessionPlayer().get();
        if (!PlayerKit.WAND_ITEM.isCompareKeyEqual(wand)) {
            return;
        }
        if (player.hasCooldown(wand)) {
            return;
        }
        wand.setCooldown(PlayerKit.WAND_COOLDOWN_GROUP, wandCooldownSeconds);
        player.setCooldown(wand, (int)(wandCooldownSeconds * 20.0));
        this.server.runTask(task -> {
            double fallDistance;
            double distance;
            if (this.sessionPlayer().isPresent() && this.sessionPlayer().get().isSneaking()) {
                distance = -downDistance;
                fallDistance = 0.0;
            } else {
                distance = upDistance;
                fallDistance = 2.0;
            }
            WorldPosition teleportLocation = player.position();
            WorldPosition platformLocation = teleportLocation.clone().floor();
            teleportLocation.setY(teleportLocation.y() + distance + fallDistance);
            platformLocation.setY(platformLocation.y() + distance);
            BingoGame.spawnPlatform(platformLocation, 1, true);
            this.server.runTask((long)Math.max(0, platformLifetimeSeconds) * 20L, laterTask -> BingoGame.removePlatform(platformLocation, 1));
            player.teleportBlocking(teleportLocation);
            player.playSound((Sound)BingoSound.GO_UP_WAND_USED.builder().build());
            player.addEffect(new PotionEffectInstance(StatusEffectType.of("minecraft:resistance"), 20 * (platformLifetimeSeconds + 4)).setAmplifier(100).setParticles(false));
            BingoReloaded.incrementPlayerStat(player, BingoStatType.WAND_USES);
        });
    }

    @Override
    public BingoSession getSession() {
        return this.session;
    }

    @Override
    @Nullable
    public BingoTeam getTeam() {
        return this.team;
    }

    @Override
    public void setTeam(@Nullable BingoTeam team) {
        this.team = team;
    }

    public String toString() {
        return this.playerName;
    }

    @Override
    @NotNull
    public Audience audience() {
        return this.sessionPlayer().isPresent() ? (Audience)this.sessionPlayer().get() : Audience.empty();
    }
}

