/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.player;

import io.github.steaf23.bingoreloaded.data.BingoMessage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public enum EffectOptionFlags {
    NIGHT_VISION(BingoMessage.EFFECTS_NIGHT_VISION.asPhrase(new Component[0])),
    WATER_BREATHING(BingoMessage.EFFECTS_WATER_BREATH.asPhrase(new Component[0])),
    FIRE_RESISTANCE(BingoMessage.EFFECTS_FIRE_RES.asPhrase(new Component[0])),
    NO_FALL_DAMAGE(BingoMessage.EFFECTS_NO_FALL_DMG.asPhrase(new Component[0])),
    SPEED(BingoMessage.EFFECTS_SPEED.asPhrase(new Component[0])),
    NO_DURABILITY(BingoMessage.EFFECTS_NO_DURABILITY.asPhrase(new Component[0])),
    KEEP_INVENTORY(BingoMessage.EFFECTS_KEEP_INVENTORY.asPhrase(new Component[0]));

    public final Component name;

    private EffectOptionFlags(Component name) {
        this.name = name;
    }

    public static Component[] effectsToText(EnumSet<EffectOptionFlags> effects) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (effects.isEmpty()) {
            result.add(Component.text("None", (TextColor)NamedTextColor.GRAY));
        } else {
            List allEffects = effects.stream().toList();
            int effectCount = allEffects.size();
            boolean firstLine = true;
            int effectPair = 0;
            while ((double)effectPair < (double)effectCount / 2.0) {
                Component effectNameLeft = ((EffectOptionFlags)((Object)allEffects.get((int)(effectPair * 2)))).name;
                TextComponent prefix = Component.text(firstLine ? " - " : "   ");
                if (effectCount > effectPair * 2 + 1) {
                    Component effectNameRight = ((EffectOptionFlags)((Object)allEffects.get((int)(effectPair * 2 + 1)))).name;
                    result.add(prefix.append(effectNameLeft.color(NamedTextColor.GRAY).append(Component.text(", ")).append(effectNameRight)));
                } else {
                    result.add(prefix.append(effectNameLeft.color(NamedTextColor.GRAY)));
                }
                firstLine = false;
                ++effectPair;
            }
        }
        return (Component[])result.toArray(Component[]::new);
    }
}

