/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.player;

import io.github.steaf23.bingoreloaded.lib.api.ServerSoftware;
import io.github.steaf23.bingoreloaded.lib.api.WorldPosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class PlayerRespawnManager {
    private final Map<UUID, DeadPlayer> deadPlayers = new HashMap<UUID, DeadPlayer>();

    public PlayerRespawnManager(ServerSoftware platform, int respawnPeriodSeconds) {
        platform.runTaskTimer(0L, 20L, t -> {
            for (UUID p : new HashSet<UUID>(this.deadPlayers.keySet())) {
                DeadPlayer player = this.deadPlayers.get(p);
                if (System.currentTimeMillis() <= player.deathTime + (long)respawnPeriodSeconds * 1000L) continue;
                this.deadPlayers.remove(p);
            }
        });
    }

    public void addPlayer(UUID playerId, WorldPosition deathLocation) {
        this.deadPlayers.put(playerId, new DeadPlayer(deathLocation, System.currentTimeMillis()));
    }

    public Optional<WorldPosition> removeDeadPlayer(UUID playerId) {
        DeadPlayer player = this.deadPlayers.remove(playerId);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(player.deathLocation);
    }

    private record DeadPlayer(WorldPosition deathLocation, Long deathTime) {
    }
}

