/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.player.team;

import io.github.steaf23.bingoreloaded.api.BingoEvents;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.TeamData;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.lib.api.PlayerGamemode;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.placeholder.BingoPlaceholderFormatter;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.BingoPlayer;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.player.team.BingoTeamContainer;
import io.github.steaf23.bingoreloaded.player.team.TeamManager;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.Nullable;

public class BasicTeamManager
implements TeamManager {
    private final BingoSession session;
    private final BingoTeamContainer activeTeams;
    private final TeamData teamData;
    private int maxTeamSize;
    private final Map<String, TeamData.TeamTemplate> joinableTeams;
    private final BingoTeam autoTeam;

    public BasicTeamManager(BingoSession session) {
        this.session = session;
        this.teamData = new TeamData();
        this.activeTeams = new BingoTeamContainer();
        this.maxTeamSize = session.settingsBuilder.view().maxTeamSize();
        this.joinableTeams = this.teamData.getTeams();
        ConsoleMessenger.log("Loaded " + this.joinableTeams.size() + " team(s)");
        TextColor autoTeamColor = TextColor.fromHexString("#fdffa8");
        if (autoTeamColor == null) {
            autoTeamColor = NamedTextColor.WHITE;
        }
        this.autoTeam = new BingoTeam("auto", autoTeamColor, BingoMessage.TEAM_AUTO.asPhrase(new Component[0]), this.createAutoPrefix(autoTeamColor));
    }

    private Component createAutoPrefix(TextColor color) {
        String prefixFormat = new BingoPlaceholderFormatter().getTeamFullFormat();
        return BingoMessage.createPhrase(prefixFormat.replace("{0}", "<" + color.toString() + ">").replace("{1}", "\u2726") + " ", new Component[0]);
    }

    private Component createPrefix(TeamData.TeamTemplate template) {
        String prefixFormat = new BingoPlaceholderFormatter().getTeamFullFormat();
        return BingoMessage.createPhrase(prefixFormat.replace("{0}", "<" + template.color().toString() + ">").replace("{1}", template.stringName()) + " ", new Component[0]);
    }

    private void addAutoPlayersToTeams() {
        Optional<BingoTeam> automaticTeamOpt = this.activeTeams.getTeams().stream().filter(t -> t.getIdentifier().equals("auto")).findFirst();
        if (automaticTeamOpt.isEmpty() || automaticTeamOpt.get().getMembers().isEmpty()) {
            return;
        }
        BingoTeam automaticTeam = automaticTeamOpt.get();
        HashSet<BingoParticipant> automaticTeamPlayers = new HashSet<BingoParticipant>(automaticTeam.getMembers());
        int overflowPlayers = this.getTotalParticipantCapacity() - this.activeTeams.getAllParticipants().size();
        if (overflowPlayers < 0) {
            ConsoleMessenger.bug("Can not fit every player into a team", (Object)this);
            return;
        }
        record TeamCount(BingoTeam team, int count) {
        }
        ArrayList<TeamCount> counts = new ArrayList<TeamCount>();
        for (BingoTeam team : this.activeTeams.getTeams()) {
            if (team.equals(automaticTeam)) continue;
            TeamCount newCount = new TeamCount(team, team.getMembers().size());
            if (counts.isEmpty()) {
                counts.add(newCount);
                continue;
            }
            int idx = 0;
            for (TeamCount tCount : counts) {
                if (newCount.count <= tCount.count) {
                    counts.add(idx, newCount);
                    break;
                }
                ++idx;
            }
            if (idx < counts.size()) continue;
            counts.add(newCount);
        }
        HashSet<BingoParticipant> autoPlayersCopy = new HashSet<BingoParticipant>(automaticTeamPlayers);
        for (BingoParticipant participant : autoPlayersCopy) {
            TeamCount lowest;
            automaticTeam.removeMember(participant);
            TeamCount teamCount = lowest = !counts.isEmpty() ? (TeamCount)counts.getFirst() : null;
            if ((counts.isEmpty() || lowest.count == this.getMaxTeamSize()) && !automaticTeamPlayers.isEmpty()) {
                BingoTeam newTeam = this.activateRandomTeam();
                if (newTeam == null) {
                    ConsoleMessenger.bug("Could not fit every player into a team, since there is not enough room!", (Object)this);
                    break;
                }
                counts.addFirst(new TeamCount(newTeam, 0));
                lowest = (TeamCount)counts.getFirst();
            }
            counts.removeFirst();
            boolean ok = this.addMemberToTeam(participant, lowest.team.getIdentifier());
            if (ok) {
                lowest = new TeamCount(lowest.team, lowest.count + 1);
                automaticTeamPlayers.remove(participant);
            }
            int idx = 0;
            for (TeamCount tCount : counts) {
                if (lowest.count <= tCount.count) {
                    counts.add(idx, lowest);
                    break;
                }
                ++idx;
            }
            if (idx < counts.size()) continue;
            counts.add(lowest);
        }
        automaticTeamPlayers.clear();
    }

    @Override
    public boolean removeMemberFromTeam(@Nullable BingoParticipant member) {
        boolean success = this.removeMemberFromTeam(member, true);
        if (success && member != null) {
            BingoMessage.LEAVE.sendToAudience((Audience)member, (TextColor)NamedTextColor.RED, new Component[0]);
        }
        return success;
    }

    public boolean removeMemberFromTeam(@Nullable BingoParticipant player, boolean clearEmptyTeams) {
        if (player == null) {
            return false;
        }
        BingoTeam team = player.getTeam();
        if (!this.getParticipants().contains(player)) {
            return false;
        }
        team.removeMember(player);
        if (clearEmptyTeams) {
            this.activeTeams.removeEmptyTeams("auto");
        }
        this.session.onParticipantLeftTeam(new BingoEvents.TeamParticipantEvent(this.session, player, team, false));
        return true;
    }

    @Override
    public int getMaxTeamSize() {
        return this.maxTeamSize;
    }

    @Override
    public int getTotalParticipantCapacity() {
        return this.joinableTeams.size() * this.getMaxTeamSize();
    }

    @Override
    public int getTeamCount() {
        return this.activeTeams.teamCount();
    }

    @Override
    public boolean addMemberToTeam(BingoParticipant participant, String teamId) {
        BingoTeam bingoTeam;
        int participantCount = this.getParticipantCount();
        BingoTeam bingoTeam2 = bingoTeam = teamId.equals("auto") ? this.autoTeam : this.activateTeamFromId(teamId);
        if (bingoTeam == null) {
            return false;
        }
        if (bingoTeam.hasMember(participant.getId())) {
            return false;
        }
        if (bingoTeam.getMembers().size() == this.getMaxTeamSize() && !bingoTeam.equals(this.autoTeam)) {
            return false;
        }
        this.removeMemberFromTeam(participant, false);
        if (participantCount == this.getParticipantCount() && participantCount >= this.getTotalParticipantCapacity()) {
            ConsoleMessenger.log(Component.text("All teams are full! (" + this.getParticipantCount() + "/" + this.getTotalParticipantCapacity() + " players), with a maximum team size of " + this.getMaxTeamSize()).color(NamedTextColor.RED));
            this.activeTeams.removeEmptyTeams("auto");
            return false;
        }
        bingoTeam.addMember(participant);
        this.activeTeams.removeEmptyTeams("auto");
        this.session.onParticipantJoinedTeam(new BingoEvents.TeamParticipantEvent(this.session, participant, bingoTeam, false));
        if (teamId.equals("auto")) {
            BingoMessage.JOIN_AUTO.sendToAudience((Audience)participant, (TextColor)NamedTextColor.GREEN, new Component[0]);
        } else {
            BingoMessage.JOIN.sendToAudience((Audience)participant, (TextColor)NamedTextColor.GREEN, bingoTeam.getColoredName());
        }
        return true;
    }

    @Override
    public Map<String, TeamData.TeamTemplate> getJoinableTeams() {
        return this.teamData.getTeams();
    }

    @Override
    public BingoTeamContainer getActiveTeams() {
        return this.activeTeams;
    }

    @Nullable
    private BingoTeam activateTeamFromId(String teamId) {
        TeamData.TeamTemplate team = this.joinableTeams.getOrDefault(teamId, null);
        if (team == null) {
            return null;
        }
        if (this.session.isRunning() && !this.activeTeams.containsId(teamId)) {
            return null;
        }
        Optional<BingoTeam> existingTeam = this.activeTeams.getById(teamId);
        if (existingTeam.isPresent()) {
            return existingTeam.get();
        }
        BingoTeam bTeam = new BingoTeam(teamId, team.color(), team.nameComponent(), this.createPrefix(team));
        this.activeTeams.addTeam(bTeam);
        return bTeam;
    }

    @Nullable
    private BingoTeam activateRandomTeam() {
        ArrayList<String> allTeams = new ArrayList<String>(this.teamData.getTeams().keySet());
        Collections.shuffle(allTeams);
        for (String teamId : allTeams) {
            if (this.activeTeams.containsId(teamId)) continue;
            return this.activateTeamFromId(teamId);
        }
        return null;
    }

    @Override
    public int getParticipantCount() {
        return this.activeTeams.getAllParticipants().size();
    }

    @Override
    public void setup() {
        this.addAutoPlayersToTeams();
        this.activeTeams.removeTeam(this.autoTeam);
        this.activeTeams.removeEmptyTeams("auto");
    }

    @Override
    public void reset() {
        this.activeTeams.addTeam(this.autoTeam);
        this.removeAbsentMembers();
    }

    @Override
    public void handleSettingsUpdated(BingoSettings newSettings) {
        int newTeamSize = newSettings.maxTeamSize();
        if (newTeamSize == this.getMaxTeamSize()) {
            return;
        }
        if (this.maxTeamSize < newTeamSize) {
            this.maxTeamSize = newTeamSize;
            return;
        }
        this.maxTeamSize = newTeamSize;
        if (!this.session.isRunning()) {
            this.getParticipants().forEach(p -> this.addMemberToTeam((BingoParticipant)p, "auto"));
            BingoMessage.TEAM_SIZE_CHANGED.sendToAudience((Audience)this.session, (TextColor)NamedTextColor.RED, new Component[0]);
        }
    }

    @Override
    public void handlePlayerLeftSessionWorld(PlayerHandle player) {
        ConsoleMessenger.log(player.displayName().append(Component.text(" left world")).color(NamedTextColor.GOLD), this.session.getOverworld().name());
    }

    @Override
    public void handlePlayerJoinedSessionWorld(PlayerHandle player) {
        ConsoleMessenger.log(player.displayName().append(Component.text(" joined world")).color(NamedTextColor.GOLD), this.session.getOverworld().name());
        BingoParticipant participant = this.getPlayerAsParticipant(player);
        if (participant != null) {
            if (!this.session.isRunning()) {
                return;
            }
            BingoMessage.JOIN.sendToAudience((Audience)participant, (TextColor)NamedTextColor.GREEN, participant.getTeam().getColoredName());
            return;
        }
        if (this.session.isRunning()) {
            player.setGamemode(PlayerGamemode.SPECTATOR);
            if (this.session.getPluginConfig().getOptionValue(BingoOptions.ALLOW_VIEWING_ALL_CARDS).booleanValue()) {
                BingoMessage.SPECTATOR_JOIN.sendToAudience((Audience)player, new Component[0]);
            } else {
                BingoMessage.SPECTATOR_JOIN_NO_VIEW.sendToAudience((Audience)player, new Component[0]);
            }
            return;
        }
        this.addMemberToTeam(new BingoPlayer(player, this.session), "auto");
    }

    private void removeAbsentMembers() {
        this.activeTeams.forEach(t -> {
            for (BingoParticipant participant : new HashSet<BingoParticipant>(t.getMembers())) {
                if (participant.alwaysActive() || !participant.sessionPlayer().isEmpty()) continue;
                this.removeMemberFromTeam(participant);
            }
        });
    }
}

