/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.player.team;

import io.github.steaf23.bingoreloaded.cards.TaskCard;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;

public class BingoTeam
implements ForwardingAudience {
    private TaskCard card;
    public boolean outOfTheGame = false;
    private final String id;
    private final TextColor color;
    private final Component name;
    private final Component prefix;
    private final Set<BingoParticipant> members;

    public BingoTeam(String identifier, TextColor color, Component name, Component prefix) {
        this.id = identifier;
        this.card = null;
        this.color = color;
        this.name = name;
        this.members = new HashSet<BingoParticipant>();
        this.prefix = prefix;
    }

    public Optional<TaskCard> getCard() {
        return Optional.ofNullable(this.card);
    }

    public void setCard(TaskCard card) {
        this.card = card;
    }

    public String getIdentifier() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public TextColor getColor() {
        return this.color;
    }

    public Component getName() {
        return this.name;
    }

    public Component getColoredName() {
        return this.name.color(this.color).decorate(TextDecoration.BOLD);
    }

    public Set<BingoParticipant> getMembers() {
        return this.members;
    }

    public void addMember(BingoParticipant player) {
        this.members.add(player);
        player.setTeam(this);
    }

    public void removeMember(@NotNull BingoParticipant player) {
        this.members.remove(player);
        player.setTeam(null);
    }

    public boolean hasMember(UUID memberId) {
        for (BingoParticipant member : this.members) {
            if (!member.getId().equals(memberId)) continue;
            return true;
        }
        return false;
    }

    public int getCompleteCount() {
        if (this.card == null) {
            ConsoleMessenger.bug("Cannot get complete count of team " + String.valueOf(this.getColoredName()), (Object)this);
            return 0;
        }
        return this.card.getCompleteCount(this);
    }

    public Set<String> getMemberNames() {
        return this.members.stream().map(BingoParticipant::getName).collect(Collectors.toSet());
    }

    public Component getPrefix() {
        return this.prefix;
    }

    @Override
    @NotNull
    public Iterable<? extends Audience> audiences() {
        return this.getMembers();
    }
}

