/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.player.team;

import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BingoTeamContainer
implements Iterable<BingoTeam> {
    private final Set<BingoTeam> teams = new HashSet<BingoTeam>();

    BingoTeamContainer() {
    }

    public int teamCount() {
        return this.teams.size();
    }

    public void addTeam(BingoTeam team) {
        this.teams.add(team);
    }

    public void removeTeam(BingoTeam team) {
        this.teams.remove(team);
    }

    @Nullable
    public BingoTeam getLeadingTeam() {
        Optional<BingoTeam> leadingTeam = this.teams.stream().max(Comparator.comparingInt(BingoTeam::getCompleteCount));
        return leadingTeam.orElse(null);
    }

    public BingoTeam getLosingTeam() {
        Optional<BingoTeam> losingTeam = this.teams.stream().min(Comparator.comparingInt(BingoTeam::getCompleteCount));
        return losingTeam.orElse(null);
    }

    public int getTotalCompleteCount() {
        int count = 0;
        for (BingoTeam team : this) {
            count += team.getCompleteCount();
        }
        return count;
    }

    public Set<BingoParticipant> getAllParticipants() {
        HashSet<BingoParticipant> allPlayers = new HashSet<BingoParticipant>();
        for (BingoTeam activeTeam : this.teams) {
            allPlayers.addAll(activeTeam.getMembers());
        }
        return allPlayers;
    }

    public Set<BingoParticipant> getAllOnlineParticipants() {
        return this.getAllParticipants().stream().filter(p -> p.sessionPlayer().isPresent() || p.alwaysActive()).collect(Collectors.toSet());
    }

    public long getOnlineTeamCount() {
        return this.teams.stream().filter(t -> t.getMembers().stream().anyMatch(player -> player.sessionPlayer().isPresent() || player.alwaysActive())).count();
    }

    public void removeEmptyTeams(String ... exceptions) {
        this.teams.removeIf(team -> team.getMembers().isEmpty() && Arrays.stream(exceptions).noneMatch(Predicate.isEqual(team.getIdentifier())));
    }

    public Set<BingoTeam> getTeams() {
        return this.teams;
    }

    public boolean containsId(String teamId) {
        return this.getById(teamId).isPresent();
    }

    public boolean contains(BingoTeam team) {
        return this.teams.contains(team);
    }

    public Optional<BingoTeam> getById(String teamId) {
        return this.teams.stream().filter(t -> t.getIdentifier().equals(teamId)).findFirst();
    }

    @Override
    @NotNull
    public Iterator<BingoTeam> iterator() {
        return this.teams.iterator();
    }
}

