/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.player.team;

import io.github.steaf23.bingoreloaded.api.BingoEvents;
import io.github.steaf23.bingoreloaded.data.BingoMessage;
import io.github.steaf23.bingoreloaded.data.TeamData;
import io.github.steaf23.bingoreloaded.data.config.BingoOptions;
import io.github.steaf23.bingoreloaded.gameloop.BingoSession;
import io.github.steaf23.bingoreloaded.lib.api.PlayerGamemode;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.lib.util.ConsoleMessenger;
import io.github.steaf23.bingoreloaded.placeholder.BingoPlaceholderFormatter;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.BingoPlayer;
import io.github.steaf23.bingoreloaded.player.team.BingoTeam;
import io.github.steaf23.bingoreloaded.player.team.BingoTeamContainer;
import io.github.steaf23.bingoreloaded.player.team.TeamManager;
import java.util.HashSet;
import java.util.Map;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.HSVLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoloTeamManager
implements TeamManager {
    private final BingoTeamContainer teams;
    private final BingoSession session;
    private final BingoTeam autoTeam;

    public SoloTeamManager(BingoSession session) {
        this.session = session;
        this.teams = new BingoTeamContainer();
        TextColor autoTeamColor = TextColor.fromHexString("#fdffa8");
        if (autoTeamColor == null) {
            autoTeamColor = NamedTextColor.WHITE;
        }
        this.autoTeam = new BingoTeam("auto", autoTeamColor, BingoMessage.TEAM_AUTO.asPhrase(new Component[0]), this.createPrefix(autoTeamColor));
        this.teams.addTeam(this.autoTeam);
    }

    private Component createPrefix(TextColor color) {
        String prefixFormat = new BingoPlaceholderFormatter().getTeamFullFormat();
        return BingoMessage.createPhrase(prefixFormat.replace("{0}", "<" + color.toString() + ">").replace("{1}", "\u2726") + " ", new Component[0]);
    }

    private TextColor determineTeamColor() {
        int max = 256;
        int divider = 1;
        int multiplier = 1;
        int amount = this.teams.teamCount() % max + 1;
        for (int i = 0; i < amount; ++i) {
            if (divider > 1) {
                multiplier += 2;
            }
            if (i < divider) continue;
            divider *= 2;
            multiplier = 1;
        }
        int hue = max / divider * multiplier;
        return TextColor.color(HSVLike.hsvLike((float)hue / 256.0f, 0.7f, 1.0f));
    }

    @Override
    public void setup() {
        this.teams.removeTeam(this.autoTeam);
        for (BingoParticipant participant : new HashSet<BingoParticipant>(this.autoTeam.getMembers())) {
            this.autoTeam.removeMember(participant);
            this.setupParticipant(participant);
        }
    }

    @Override
    public void reset() {
        for (BingoTeam team : new HashSet<BingoTeam>(this.teams.getTeams())) {
            for (BingoParticipant member : new HashSet<BingoParticipant>(team.getMembers())) {
                this.removeMemberFromTeam(member);
            }
            this.teams.removeTeam(team);
        }
        this.teams.addTeam(this.autoTeam);
    }

    public void setupParticipant(BingoParticipant participant) {
        TextColor teamColor = this.determineTeamColor();
        BingoTeam team = new BingoTeam(participant.getId().toString(), teamColor, participant.getDisplayName(), this.createPrefix(teamColor));
        team.addMember(participant);
        this.teams.addTeam(team);
        BingoMessage.JOIN.sendToAudience((Audience)participant, (TextColor)NamedTextColor.GREEN, participant.getTeam().getColoredName());
        this.session.onParticipantJoinedTeam(new BingoEvents.TeamParticipantEvent(this.session, participant, team, false));
    }

    @Override
    public Map<String, TeamData.TeamTemplate> getJoinableTeams() {
        return Map.of();
    }

    @Override
    public BingoTeamContainer getActiveTeams() {
        return this.teams;
    }

    @Override
    public boolean addMemberToTeam(BingoParticipant player, String teamId) {
        if (this.session.isRunning()) {
            return false;
        }
        this.autoTeam.addMember(player);
        this.session.onParticipantJoinedTeam(new BingoEvents.TeamParticipantEvent(this.session, player, null, true));
        BingoMessage.JOIN_AUTO.sendToAudience((Audience)player, (TextColor)NamedTextColor.GREEN, new Component[0]);
        return true;
    }

    @Override
    public boolean removeMemberFromTeam(@Nullable BingoParticipant member) {
        if (member == null) {
            return false;
        }
        this.removeMemberFromTeamSilently(member);
        this.session.onParticipantLeftTeam(new BingoEvents.TeamParticipantEvent(this.session, member, null, true));
        BingoMessage.LEAVE.sendToAudience((Audience)member, (TextColor)NamedTextColor.RED, new Component[0]);
        return true;
    }

    @Override
    public int getMaxTeamSize() {
        return 1;
    }

    @Override
    public int getTotalParticipantCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void handlePlayerJoinedSessionWorld(PlayerHandle player) {
        ConsoleMessenger.log(player.displayName().append(Component.text(" joined world")).color(NamedTextColor.GOLD), this.session.getOverworld().name());
        BingoParticipant participant = this.getPlayerAsParticipant(player);
        if (participant != null) {
            if (!this.session.isRunning()) {
                return;
            }
            BingoMessage.JOIN.sendToAudience((Audience)participant, (TextColor)NamedTextColor.GREEN, participant.getTeam().getColoredName());
            return;
        }
        if (this.session.isRunning()) {
            player.setGamemode(PlayerGamemode.SPECTATOR);
            if (this.session.getPluginConfig().getOptionValue(BingoOptions.ALLOW_VIEWING_ALL_CARDS).booleanValue()) {
                BingoMessage.SPECTATOR_JOIN.sendToAudience((Audience)player, new Component[0]);
            } else {
                BingoMessage.SPECTATOR_JOIN_NO_VIEW.sendToAudience((Audience)player, new Component[0]);
            }
            return;
        }
        this.addMemberToTeam(new BingoPlayer(player, this.session), "auto");
    }

    @Override
    public void handlePlayerLeftSessionWorld(PlayerHandle player) {
        ConsoleMessenger.log(player.displayName().append(Component.text(" left world")).color(NamedTextColor.GOLD), this.session.getOverworld().name());
    }

    private void removeMemberFromTeamSilently(@NotNull BingoParticipant member) {
        for (BingoTeam team : this.teams) {
            team.removeMember(member);
        }
        this.teams.removeEmptyTeams("auto");
    }
}

