/*
 * Decompiled with CFR 0.152.
 */
package io.github.steaf23.bingoreloaded.player.team;

import io.github.steaf23.bingoreloaded.data.TeamData;
import io.github.steaf23.bingoreloaded.lib.api.player.PlayerHandle;
import io.github.steaf23.bingoreloaded.player.BingoParticipant;
import io.github.steaf23.bingoreloaded.player.team.BingoTeamContainer;
import io.github.steaf23.bingoreloaded.settings.BingoSettings;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TeamManager {
    public void setup();

    public void reset();

    default public int getParticipantCount() {
        return this.getParticipants().size();
    }

    default public Set<BingoParticipant> getParticipants() {
        return this.getActiveTeams().getAllParticipants();
    }

    public Map<String, TeamData.TeamTemplate> getJoinableTeams();

    public BingoTeamContainer getActiveTeams();

    @Nullable
    default public BingoParticipant getPlayerAsParticipant(@NotNull PlayerHandle player) {
        for (BingoParticipant participant : this.getParticipants()) {
            if (!participant.getId().equals(player.uniqueId())) continue;
            return participant;
        }
        return null;
    }

    default public int getTeamCount() {
        return this.getActiveTeams().teamCount();
    }

    public boolean addMemberToTeam(BingoParticipant var1, String var2);

    public boolean removeMemberFromTeam(@Nullable BingoParticipant var1);

    public int getMaxTeamSize();

    public int getTotalParticipantCapacity();

    default public void handleSettingsUpdated(BingoSettings newSettings) {
    }

    default public void handlePlayerJoinedSessionWorld(PlayerHandle player) {
    }

    default public void handlePlayerLeftSessionWorld(PlayerHandle player) {
    }
}

